<?php namespace App\Http\Controllers;

use App\Spsinfo;
use App\Transactionlog;
use App\Transfererrorlog;
use App\Billeterror;
use App\Client;
use App\Multisafe;
use App\Usedavailablelimit;
use App\Spsbank;

use App\Transferlog;
use App\Darfpayment;
use App\Darjpayment;
use App\Fgtspayment;
use App\Gpspayment;
use App\Garepayment;
use App\Barcodepayment;
use App\Billet;
use App\MonthlyFeePayment;

use DB;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use App\Exports\ReportExport;
use Maatwebsite\Excel\Facades\Excel;

class SpsinfoController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /* ADMIN */
    public function index()
    {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        $spsinfos = Spsinfo::first();

        $spsInfo = getSPS();
        $datade  = date('Y/m/d', strtotime('-7 days'));
        $dataate = date('Y/m/d');
        $curlParams = "{ \"Method\": \"GetAccountEntry\",
                            \"PartnerId\": ".$spsInfo->partnerid.",
                            \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                            \"TaxNumber\": \"".$spsInfo->cnpj."\",
                            \"StartDate\": \"".$datade."\",
                            \"EndDate\": \"".$dataate."\"
                        }";

        $extrato = sendCurl($curlParams);

        $msg = false;

        if($extrato["Success"] == "false") { $msg = 'Ocorreu um problema ao solicitar o saldo SPS.'; $extrato['Balance'] = 0;}

        return view('sps.index',compact('spsinfos','extrato'))->with('status',$msg);
    }

    public function editspsinfo(Request $request, $id)
    {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        $spsinfos = Spsinfo::findOrFail($id);

        return view('sps.editinfo',compact('spsinfos'));
    }

    public function update(Request $request)
    {
        $spsinfos = Spsinfo::findOrFail($request->id);

        $request->merge([
            'fitbankpayments' => covert2Float($request->fitbankpayments),
            'fitbanktransfers' => covert2Float($request->fitbanktransfers),
            'fitbankbillets' => covert2Float($request->fitbankbillets),
            'fitbankp2p' => covert2Float($request->fitbankp2p),
            'clientpayments' => covert2Float($request->clientpayments),
            'clienttransfers' => covert2Float($request->clienttransfers),
            'clientbillets' => covert2Float($request->clientbillets),
            'clientbalanceusage' => covert2Float($request->clientbalanceusage),
            'cnpj' => somenteNumeros($request->cnpj),
            'supplierphone' => somenteNumeros($request->supplierphone),
            'clientbalanceusagedailycharge' => covert2Float($request->clientbalanceusagedailycharge)
        ]);

        $spsinfos->update($request->all());

        $spsInfo = getSPS();
        $datade  = date('Y/m/d', strtotime('-7 days'));
        $dataate = date('Y/m/d');
        $curlParams = "{ \"Method\": \"GetAccountEntry\",
                            \"PartnerId\": ".$spsInfo->partnerid.",
                            \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                            \"TaxNumber\": \"".$spsInfo->cnpj."\",
                            \"StartDate\": \"".$datade."\",
                            \"EndDate\": \"".$dataate."\"
                        }";

        $extrato = sendCurl($curlParams);

        $msg = false;

        if($extrato["Success"] == "false") { $msg = 'Ocorreu um problema ao solicitar o saldo SPS.'; $extrato['Balance'] = 0;}


        return view('sps.index',compact('spsinfos','extrato'))->with('status', 'Informações atualizadas');
    }

    public function extrato(Request $request) {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        $spsInfo = getSPS();

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');
        }

        $curlParams = "{ \"Method\": \"GetAccountEntry\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".$spsInfo->cnpj."\",
                    \"StartDate\": \"".$datade."\",
                    \"EndDate\": \"".$dataate."\"
                }";

        $extrato = sendCurl($curlParams);

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate));

        return view('sps.extrato',compact('extrato','datafiltro'));
    }

    /* REALIZA TRANSFERÊNCIA PARA A CONTA MÃE */
    public function transferenciasps() {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        return view('sps.transferenciasps');
    }

    public function realizatransferenciasps(Request $request) {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        /*MktPlaceId: 15084
        Partner Id: 368
        Business Unit Id: 358*/

        $spsInfo = getSPS();

        $dataAtual = date("Y/m/d");

        $valor = str_replace(',', '.', str_replace('.', '', $request->amount));

        $curlParams = "{ \"Method\": \"MoneyTransferIn\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"MktPlaceId\": ".$spsInfo->mktplaceid.",
                    \"SupplierName\": \"".$spsInfo->name."\",
                    \"SupplierTaxNumber\": ".$spsInfo->cnpj.",
                    \"SupplierTradingName\": \"".$spsInfo->name."\",
                    \"SupplierMail\": \"".$spsInfo->suppliermail."\",
                    \"SupplierPhone\": \"".$spsInfo->supplierphone."\",
                    \"BankNumber\": \"".$spsInfo->banknumber."\",
                    \"BankBranch\": \"".$spsInfo->bankbranch."\",
                    \"BankAccount\": \"".$spsInfo->bankaccount."\",
                    \"TransferDate\": \"".$dataAtual."\",
                    \"TotalValue\": ".$valor.",
                    \"RateValue\": 0,
                    \"Products\": []
                }";

        $transfere = sendCurl($curlParams);

        $transactionNumber = (isset($transfere['DocumentNumber']))?$transfere['DocumentNumber']:'0';
        $sucesso = ($transfere["Success"] == "false")?0:1;
        $validacao = (isset($transfere['Validation']))?serialize($transfere['Validation']):'';
        $mensagem = (isset($transfere['Message']))?$transfere['Message']:'';

        saveTransactionLog('0',$spsInfo->cnpj,'MoneyTransferIn',$curlParams,$sucesso,$mensagem,$validacao,$transactionNumber,$valor,date('Y-m-d H:i:s'),0);

        if($transfere["Success"] == "false") return redirect('/transferenciasps')->with('warning', 'Erro: ocorreu um problema ao processar a requisição.'.$transfere['Message']);

        return view('sps.transferenciaspsok',compact('transfere'))->with('status', 'Transferência efetuada.');

    }

    public function logtransferencias(Request $request) {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-7 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-d', strtotime('-7 days'));
            $dataate = date('Y-m-d');
        }

        $q_tlogsok = Transactionlog::select('user_id','client_id','taxnumber','actiondate','success','message','entry','balance','method','status')
                            ->whereDate('actiondate','>=',$datade)
                            ->whereDate('actiondate','<=',$dataate);

        if(isset($request) && $request->filtrostatus != '')
            $q_tlogsok->where('status','LIKE',$request->filtrostatus.'%');

        if(isset($request) && $request->method != '')
            $q_tlogsok->where('method','=',$request->method);


        $tlogsok = $q_tlogsok->orderBy('created_at','desc')->get();

        /* ************* COM ERRO ************** */
        $q_tlogserr = Transfererrorlog::select('user_id','client_id',DB::raw('"" as taxnumber'),'actiondate',DB::raw('"0" as success'),
                                                'message',DB::raw('"" as entry'),DB::raw('"" as balance'),'method',DB::raw('"Error" as status'))
                            ->where('method','=','InternalTransfer')
                            ->whereDate('actiondate','>=',$datade)
                            ->whereDate('actiondate','<=',$dataate);

        // if(isset($request) && $request->filtrostatus != '')
        //     $q_tlogserr->where('status','LIKE',$request->filtrostatus.'%');

        if(isset($request) && $request->method != '')
            $q_tlogserr->where('method','=',$request->method);


        $tlogserr = $q_tlogserr->orderBy('created_at','desc')->get();
        /* ************* COM ERRO ************** */

        $tlogs = $tlogsok->concat($tlogserr);

        $tlogs->sortBy('actiondate');

        $filtrostatus  = (isset($request) && $request->filtrostatus != '')?$request->filtrostatus:'';
        $filtroMetodo  = (isset($request) && $request->method != '')?$request->method:'';

        $datafiltro = array('datade'=>date2br($datade),'dataate'=>date2br($dataate), 'filtrostatus'=>$filtrostatus,'filtroMetodo'=>$filtroMetodo);

        return view('sps.logtransferencias',compact('tlogs','datafiltro'));
    }


    public function erropagamentos(Request $request) {

        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-3 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-d', strtotime('-3 days'));
            $dataate = date('Y-m-d');
        }

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';
        $filtroMetodo  = (isset($request) && $request->method != '')?$request->method:'';

        $tlogs = Transfererrorlog::select('transfererrorlogs.id',
                                            'transfererrorlogs.method',
                                            'transfererrorlogs.actiondate',
                                            'transfererrorlogs.datasent',
                                            'transfererrorlogs.message',
                                            'transfererrorlogs.validation',
                                            'clients.name as client',
                                            'users.name'
                            )
                            ->join('clients','clients.id','=','transfererrorlogs.client_id')
                            ->join('users','users.id','=','transfererrorlogs.user_id')
                            ->whereDate('transfererrorlogs.actiondate','>=',$datade)
                            ->whereDate('transfererrorlogs.actiondate','<=',$dataate);


        if(isset($request) && $request->method != '')
            $tlogs->where('transfererrorlogs.method','=',$request->method);

        if(isset($request) && $request->client_id != '')
            $tlogs->where('transfererrorlogs.client_id','=',$request->client_id);


        $erros = $tlogs->orderBy('transfererrorlogs.created_at','desc')->get();

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate),'filtroCliente'=>$filtroCliente,'filtroMetodo'=>$filtroMetodo);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.erropagamentos',compact('erros','datafiltro','clients'));
    }

    public function erroboletos(Request $request) {

        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-3 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-d', strtotime('-3 days'));
            $dataate = date('Y-m-d');
        }

        $tlogs = Billeterror::select('billeterrors.id',
                                            'billeterrors.emission as actiondate',
                                            'billeterrors.datasent',
                                            'billeterrors.message',
                                            'billeterrors.validation',
                                            'clients.name as client',
                                            'users.name'
                            )
                            ->join('clients','clients.id','=','billeterrors.client_id')
                            ->join('users','users.id','=','billeterrors.user_id')
                            ->whereDate('billeterrors.emission','>=',$datade)
                            ->whereDate('billeterrors.emission','<=',$dataate);


        if(isset($request) && $request->client_id != '')
            $tlogs->where('billeterrors.client_id','=',$request->client_id);


        $erros = $tlogs->orderBy('billeterrors.created_at','desc')->get();

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate),'filtroCliente'=>$filtroCliente);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.erroboletos',compact('erros','datafiltro','clients'));
    }

    public function errotransferencias(Request $request) {

        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-3 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-d', strtotime('-3 days'));
            $dataate = date('Y-m-d');
        }

        $tlogs = Transfererrorlog::select('transfererrorlogs.id',
                                            'transfererrorlogs.method',
                                            'transfererrorlogs.actiondate',
                                            'transfererrorlogs.datasent',
                                            'transfererrorlogs.message',
                                            'transfererrorlogs.validation',
                                            'clients.name as client',
                                            'users.name'
                            )
                            ->leftJoin('clients','clients.id','=','transfererrorlogs.client_id')
                            ->join('users','users.id','=','transfererrorlogs.user_id')
                            ->whereDate('transfererrorlogs.actiondate','>=',$datade)
                            ->whereDate('transfererrorlogs.actiondate','<=',$dataate);


        if(isset($request) && $request->method != '')
            $tlogs->where('transfererrorlogs.method','=',$request->method);

        if(isset($request) && $request->client_id != '')
            $tlogs->where('transfererrorlogs.client_id','=',$request->client_id);


        $erros = $tlogs->orderBy('transfererrorlogs.created_at','desc')->get();

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate),'filtroCliente'=>$filtroCliente);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.errotransferencias',compact('erros','datafiltro','clients'));
    }


    public function logsaldodisponivel(Request $request) {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-3 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-d', strtotime('-3 days'));
            $dataate = date('Y-m-d');
        }
        $q_logs = Usedavailablelimit::select('usedavailablelimits.id',
                                            'usedavailablelimits.client_id',
                                            'usedavailablelimits.emission',
                                            'usedavailablelimits.requestedvalue',
                                            'usedavailablelimits.ratevalue',
                                            'usedavailablelimits.transactiontype',
                                            'usedavailablelimits.status',
                                            'usedavailablelimits.daysused',
                                            'usedavailablelimits.interestvalue',
                                            'usedavailablelimits.paymentdate',
                                            'usedavailablelimits.paid',
                                            'clients.name as client'
                            )
                            ->leftJoin('clients','clients.id','=','usedavailablelimits.client_id')
                            ->whereDate('usedavailablelimits.emission','>=',$datade)
                            ->whereDate('usedavailablelimits.emission','<=',$dataate);

        if(isset($request) && $request->status != '')
            $q_logs->where('usedavailablelimits.paid','=',$request->status);

        if(isset($request) && $request->client_id != '')
            $q_logs->where('usedavailablelimits.client_id','=',$request->client_id);

        $tlogs = $q_logs->orderBy('usedavailablelimits.created_at','desc')->get();

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';
        $filtroStatus = (isset($request) && $request->status != '')?$request->status:'';

        $filtros = array('datade'=>detectDateFormatOutputDateBr($datade),'dataate'=>detectDateFormatOutputDateBr($dataate),'filtroCliente'=>$filtroCliente,'filtroStatus'=>$filtroStatus);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.logsaldodisponivel',compact('tlogs','filtros','clients'));
    }


    public function transferenciarapida(Request $request) {

        //$clients = Client::orderBy('name','ASC')->get();

        $first = Client::select('id',
                                'name',
                                'taxnumber',
                                'availablelimit'
                               );
        $clients = Multisafe::select('client_id as id',
                                     'nickname as name',
                                     'taxnumber',
                                     'availablelimit'
                                    )->union($first)->orderBy('name','ASC')->get();

        return view('sps.transferenciarapida',compact('clients'));

    }

    public function spsbanks(Request $request) {

        $bank = new Spsbank();

        $bankinfo = explode('*',$request->bankname);

        $bank->spsinfo_id = $request->spsinfo_id;
        $bank->user_id = Auth::user()->id;
        $bank->nickname = $request->nickname;
        $bank->bankname = $bankinfo[1];
        $bank->bankcode = $bankinfo[0];
        $bank->bankbranch = $request->bankbranch;
        $bank->bankaccount = $request->bankaccount;
        $bank->bankaccountdigit = $request->bankaccountdigit;
        $bank->billpayments = covert2Float($request->billpayments);
        $bank->transfers = covert2Float($request->transfers);
        $bank->billets = covert2Float($request->billets);

        $bank->save();

        if(!$bank) return redirect('/spsinfo')->with('danger', 'Não foi possível salvar. Tente mais tarde.');
        return redirect('/spsinfo')->with('success', 'Conta adicionada com sucesso.');
    }

    public function spsbanksRemove(Request $request) {
        $bank = Spsbank::where('id','=',$request->id)->first();
        $bank->delete();

        if(!$bank) return redirect('/spsinfo')->with('danger', 'Não foi possível excluir.');
        return redirect('/spsinfo')->with('status', 'Banco removido com sucesso.');
    }

    /* *******************************************************************
   ************************ RELATORIOS SIMPLES *****************************
   ****************************************************************** */
    public function relatoriosTarifasSimples(Request $request) {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-3 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-01');
            $dataate = date('Y-m-d');
        }

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';
        $filtroMensalidade = (isset($request) && $request->mensalidade != '')?$request->mensalidade:1;

        $q_listclients = Client::select('id','name')->orderBy('name','ASC');

        if(isset($request) && $request->client_id != '')
                $q_listclients->where('id','=',$request->client_id);

        $listclients = $q_listclients->get();

        $relatorio = [];

        $sps = getSPS();

        foreach($listclients as $cli) {
            $relatorio[] = [ "client" => $cli->name,
                                "report" => $this->relatoriosSimples(['datade'=>$datade, 'dataate'=>$dataate, 'client_id' => $cli->id, 'mensalidade' => $filtroMensalidade])
                            ];

        }

        $filtros = array('datade'=>detectDateFormatOutputDateBr($datade),'dataate'=>detectDateFormatOutputDateBr($dataate),'filtroCliente'=>$filtroCliente,'filtroMensalidade'=>$filtroMensalidade);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.relatorio_tarifassimples',compact('relatorio','filtros','clients'));

    }


    /* *******************************************************************
   ************************ RELATORIOS DETALHADO *****************************
   ****************************************************************** */
    public function relatoriosTarifasDetalhado(Request $request) {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-3 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-01');
            $dataate = date('Y-m-d');
        }

        $q_listclients = Client::select('id','name')->orderBy('name','ASC');

        if(isset($request) && $request->client_id != '')
                $q_listclients->where('id','=',$request->client_id);

        $listclients = $q_listclients->get();

        $relatorio = [];

        $sps = getSPS();

        foreach($listclients as $cli) {
            // transfer
            $q_transfer = Transferlog::select('id','actiondate as emission','ratevalue', DB::raw('"Transferência" as type'), DB::raw('"'.$sps->fitbanktransfers.'" as fitvalue') )
                                ->where('client_id','=',$cli->id)
                                ->whereDate('actiondate','>=',$datade)
                                ->whereDate('actiondate','<=',$dataate);

            $transfer = $q_transfer->get();

            // billets
            $q_billets = Billet::select('id','emission','ratevalue', DB::raw('"Boleto" as type'), DB::raw('"'.$sps->fitbankbillets.'" as fitvalue'))
                                ->where('client_id','=',$cli->id)
                                ->whereDate('emission','>=',$datade)
                                ->whereDate('emission','<=',$dataate);

            $billets = $q_billets->get();

            // Usedavailablelimit
            $q_availablelimit = Usedavailablelimit::select('id','emission','ratevalue', DB::raw('"Adiantamento" as type'), DB::raw('"0" as fitvalue'))
                                ->where('client_id','=',$cli->id)
                                ->whereDate('emission','>=',$datade)
                                ->whereDate('emission','<=',$dataate);

            $availablelimit = $q_availablelimit->get();

            // MonthlyFeePayment
            $q_monthlyfee = MonthlyFeePayment::select('id','paymentdate as emission','value as ratevalue', DB::raw('"Mensalidade" as type'), DB::raw('"'.$sps->fitbankp2p.'" as fitvalue'))
                                ->where('client_id','=',$cli->id)
                                ->where('status','=','1')
                                ->whereDate('paymentdate','>=',$datade)
                                ->whereDate('paymentdate','<=',$dataate);

            $monthlyfee = $q_monthlyfee->get();


            if(isset($request) && $request->mensalidade == 1) {
                $report = $transfer->concat($billets)
                                ->concat($availablelimit)
                                ->concat($monthlyfee);
            } else {
                $report = $transfer->concat($billets)
                                ->concat($availablelimit);
            }

            $relatorio[] = [ "client" => $cli->name,
                                "report" => $report->sortBy('emission')
                        ];

        }

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';
        $filtroMensalidade = (isset($request) && $request->mensalidade != '')?$request->mensalidade:1;

        $filtros = array('datade'=>detectDateFormatOutputDateBr($datade),'dataate'=>detectDateFormatOutputDateBr($dataate),'filtroCliente'=>$filtroCliente,'filtroMensalidade'=>$filtroMensalidade);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.relatorio_tarifasdetalhado',compact('relatorio','filtros','clients'));
    }


    public function relatoriosTarifasGraficos(Request $request) {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-3 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-01');
            $dataate = date('Y-m-d');
        }

        $relatorio = [];

        $sps = getSPS();

        // darf
        $q_darf = Darfpayment::select('id')
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_darf->where('client_id','=',$request->client_id);

        $darf = $q_darf->count();

        // darj
        $q_darj = Darjpayment::select('id')
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_darj->where('client_id','=',$request->client_id);

        $darj = $q_darj->count();

        // fgts
        $q_fgts = Fgtspayment::select('id')
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_fgts->where('client_id','=',$request->client_id);

        $fgts = $q_fgts->count();

        // gps
        $q_gps = Gpspayment::select('id')
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_gps->where('client_id','=',$request->client_id);

        $gps = $q_gps->count();

        // gare
        $q_gare = Garepayment::select('id')
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_gare->where('client_id','=',$request->client_id);

        $gare = $q_gare->count();

        // barcode
        $q_barcodepayment = Barcodepayment::select('id')
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_barcodepayment->where('client_id','=',$request->client_id);

        $barcodepayment = $q_barcodepayment->count();

        // transfer
        $q_transfer = Transferlog::select('id','ratevalue')
                            ->whereDate('actiondate','>=',$datade)
                            ->whereDate('actiondate','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_transfer->where('client_id','=',$request->client_id);

        $c_transfer = clone $q_transfer;

        $transfer = $q_transfer->count();
        $transfersum = $c_transfer->sum('ratevalue');

        // billets
        $q_billets = Billet::select('id','ratevalue')
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_billets->where('client_id','=',$request->client_id);

        $c_billets = clone $q_billets;

        $billets = $q_billets->count();
        $billetssum = $c_billets->sum('ratevalue');

        // Usedavailablelimit
        $q_availablelimit = Usedavailablelimit::select('id','ratevalue')
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_availablelimit->where('client_id','=',$request->client_id);

        $c_availablelimit = clone $q_availablelimit;

        $availablelimit = $q_availablelimit->count();
        $availablelimitsum = $c_availablelimit->sum('ratevalue');

        // MonthlyFeePayment
        $q_monthlyfee = MonthlyFeePayment::select('id','value')
                            ->where('status','=','1')
                            ->whereDate('paymentdate','>=',$datade)
                            ->whereDate('paymentdate','<=',$dataate);

            if(isset($request) && $request->client_id != '')
                $q_monthlyfee->where('client_id','=',$request->client_id);

        $c_monthlyfee = clone $q_monthlyfee;

        $monthlyfee = $q_monthlyfee->count();
        $monthlyfeesum = $c_monthlyfee->sum('value');


        $relatorio = [
                        'darf' =>
                            ['quantity'=> $darf,          'fitvalue'=> $darf * $sps->fitbankpayments,           'type'=> 'DARF',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'darj' =>
                            ['quantity'=> $darj,          'fitvalue'=> $darj * $sps->fitbankpayments,           'type'=> 'DARJ',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'fgts' =>
                            ['quantity'=> $fgts,          'fitvalue'=> $fgts * $sps->fitbankpayments,           'type'=> 'FGTS',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'gps' =>
                            ['quantity'=> $gps,           'fitvalue'=> $gps * $sps->fitbankpayments,            'type'=> 'GPS',            'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'gare' =>
                            ['quantity'=> $gare,          'fitvalue'=> $gare * $sps->fitbankpayments,           'type'=> 'GARE',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'barcodepayment' =>
                            ['quantity'=> $barcodepayment,'fitvalue'=> $barcodepayment * $sps->fitbankpayments, 'type'=> 'Pagamentos',     'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'transfer' =>
                            ['quantity'=> $transfer,      'fitvalue'=> $transfer * $sps->fitbanktransfers,      'type'=> 'Transferências', 'feetype'=> 'transferencia', 'totalvalue'=> $transfersum, 'show'=> 1]
                        ,
                        'billets' =>
                            ['quantity'=> $billets,       'fitvalue'=> $billets * $sps->fitbankbillets,         'type'=> 'Boletos',        'feetype'=> 'boleto',        'totalvalue'=> $billetssum, 'show'=> 1]
                        ,
                        'monthlyfee' =>
                            ['quantity'=> $monthlyfee,    'fitvalue'=> 0,                                       'type'=> 'Tarifa mensal',  'feetype'=> 'mensalidade',   'totalvalue'=> $monthlyfeesum, 'show'=> $request->mensalidade]
                        ,
                        'availablelimit' =>
                            ['quantity'=> $availablelimit,'fitvalue'=> $availablelimit * $sps->fitbankp2p,             'type'=> 'Adiantamento',   'feetype'=> 'p2p',           'totalvalue'=> $availablelimitsum, 'show'=> 1]
                        ,
                    ];


        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';
        $filtroMensalidade = (isset($request) && $request->mensalidade != '')?$request->mensalidade:1;

        $filtros = array('datade'=>detectDateFormatOutputDateBr($datade),'dataate'=>detectDateFormatOutputDateBr($dataate),'filtroCliente'=>$filtroCliente,'filtroMensalidade'=>$filtroMensalidade);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.relatorio_graficos',compact('relatorio','filtros','clients'));
    }

    public function relatoriosTarifasComparativos(Request $request) {

        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if($request->isMethod('get')) {
            $mesanoatual    = date('Y-m-d');
            $mesanoanterior = date('Y-m-d', strtotime('-1 months',strtotime($mesanoatual)));
            $p1 = explode('-',$mesanoatual);
            $p2 = explode('-',$mesanoanterior);

            $filtromes2 = $p1[1];
            $filtroano2 = $p1[0];
            $filtromes1 = $p2[1];
            $filtroano1 = $p2[0];
        } else {
            $filtromes1 = $request->filtromes1;
            $filtroano1 = $request->filtroano1;
            $filtromes2 = $request->filtromes2;
            $filtroano2 = $request->filtroano2;
        }

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';

        $relatorio = [
            'param1' => $this->relatoriosComparativos(['filtromes'=>$filtromes1, 'filtroano'=>$filtroano1, 'client_id' => $filtroCliente]),
            'param2' => $this->relatoriosComparativos(['filtromes'=>$filtromes2, 'filtroano'=>$filtroano2, 'client_id' => $filtroCliente]),
        ];

        $filtros = array(
            'filtromes1'=>$filtromes1,
            'filtroano1'=>$filtroano1,
            'filtromes2'=>$filtromes2,
            'filtroano2'=>$filtroano2,
            'filtroCliente'=>$filtroCliente);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.relatorio_comparativo',compact('relatorio','filtros','clients'));
    }

    public function relatoriosTarifasAnual(Request $request) {

        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if($request->isMethod('get')) {
            $filtroano = date('Y');
        } else {
            $filtroano = $request->filtroano;
        }

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';

        $relatorio = [
            '01' => $this->relatoriosComparativos(['filtromes'=>'01', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '02' => $this->relatoriosComparativos(['filtromes'=>'02', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '03' => $this->relatoriosComparativos(['filtromes'=>'03', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '04' => $this->relatoriosComparativos(['filtromes'=>'04', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '05' => $this->relatoriosComparativos(['filtromes'=>'05', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '06' => $this->relatoriosComparativos(['filtromes'=>'06', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '07' => $this->relatoriosComparativos(['filtromes'=>'07', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '08' => $this->relatoriosComparativos(['filtromes'=>'08', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '09' => $this->relatoriosComparativos(['filtromes'=>'09', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '10' => $this->relatoriosComparativos(['filtromes'=>'10', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '11' => $this->relatoriosComparativos(['filtromes'=>'11', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
            '12' => $this->relatoriosComparativos(['filtromes'=>'12', 'filtroano'=>$filtroano, 'client_id' => $filtroCliente]),
        ];

        $filtros = array(
            'filtroano'=>$filtroano,
            'filtroCliente'=>$filtroCliente);

        $clients = Client::select('id','name')->orderBy('name','ASC')->get();

        return view('sps.relatorio_anual',compact('relatorio','filtros','clients'));
    }


    /*************************************************
    *
    * RELATORIOS COMPARATIVOS
    *
    *
    */

    public static function relatoriosComparativos($filtro) {

        $relatorio = [];

        $sps = getSPS();

        // darf
        $q_darf = Darfpayment::select('id')
                            ->whereYear('emission','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_darf->whereMonth('emission','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_darf->where('client_id','=',$filtro['client_id']);

        $darf = $q_darf->count();

        // darj
        $q_darj = Darjpayment::select('id')
                            ->whereYear('emission','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_darj->whereMonth('emission','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')

                $q_darj->where('client_id','=',$filtro['client_id']);

        $darj = $q_darj->count();

        // fgts
        $q_fgts = Fgtspayment::select('id')
                            ->whereYear('emission','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_fgts->whereMonth('emission','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_fgts->where('client_id','=',$filtro['client_id']);

        $fgts = $q_fgts->count();

        // gps
        $q_gps = Gpspayment::select('id')
                            ->whereYear('emission','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_gps->whereMonth('emission','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_gps->where('client_id','=',$filtro['client_id']);

        $gps = $q_gps->count();

        // gare
        $q_gare = Garepayment::select('id')
                            ->whereYear('emission','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_gare->whereMonth('emission','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_gare->where('client_id','=',$filtro['client_id']);

        $gare = $q_gare->count();

        // barcode
        $q_barcodepayment = Barcodepayment::select('id')
                            ->whereYear('emission','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_barcodepayment->whereMonth('emission','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_barcodepayment->where('client_id','=',$filtro['client_id']);

        $barcodepayment = $q_barcodepayment->count();

        // transfer
        $q_transfer = Transferlog::select('id','ratevalue')
                            ->whereYear('actiondate','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_transfer->whereMonth('actiondate','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_transfer->where('client_id','=',$filtro['client_id']);

        $c_transfer = clone $q_transfer;

        $transfer = $q_transfer->count();
        $transfersum = $c_transfer->sum('ratevalue');

        // billets
        $q_billets = Billet::select('id','ratevalue')
                            ->whereYear('emission','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_billets->whereMonth('emission','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_billets->where('client_id','=',$filtro['client_id']);

        $c_billets = clone $q_billets;

        $billets = $q_billets->count();
        $billetssum = $c_billets->sum('ratevalue');

        // Usedavailablelimit
        $q_availablelimit = Usedavailablelimit::select('id','ratevalue')
                            ->whereYear('emission','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_availablelimit->whereMonth('emission','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_availablelimit->where('client_id','=',$filtro['client_id']);

        $c_availablelimit = clone $q_availablelimit;

        $availablelimit = $q_availablelimit->count();
        $availablelimitsum = $c_availablelimit->sum('ratevalue');

        // MonthlyFeePayment
        $q_monthlyfee = MonthlyFeePayment::select('id','value')
                            ->where('status','=','1')
                            ->whereYear('paymentdate','=',$filtro['filtroano']);

            if($filtro['filtromes'] != '00')
                $q_monthlyfee->whereMonth('paymentdate','=',$filtro['filtromes']);

            if($filtro['client_id'] != '')
                $q_monthlyfee->where('client_id','=',$filtro['client_id']);

        $c_monthlyfee = clone $q_monthlyfee;

        $monthlyfee = $q_monthlyfee->count();
        $monthlyfeesum = $c_monthlyfee->sum('value');


        $relatorio = [
                        'darf' =>
                            ['quantity'=> $darf,          'fitvalue'=> $darf * $sps->fitbankpayments,           'type'=> 'DARF',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'darj' =>
                            ['quantity'=> $darj,          'fitvalue'=> $darj * $sps->fitbankpayments,           'type'=> 'DARJ',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'fgts' =>
                            ['quantity'=> $fgts,          'fitvalue'=> $fgts * $sps->fitbankpayments,           'type'=> 'FGTS',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'gps' =>
                            ['quantity'=> $gps,           'fitvalue'=> $gps * $sps->fitbankpayments,            'type'=> 'GPS',            'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'gare' =>
                            ['quantity'=> $gare,          'fitvalue'=> $gare * $sps->fitbankpayments,           'type'=> 'GARE',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'barcodepayment' =>
                            ['quantity'=> $barcodepayment,'fitvalue'=> $barcodepayment * $sps->fitbankpayments, 'type'=> 'Pagamentos',     'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1]
                        ,
                        'transfer' =>
                            ['quantity'=> $transfer,      'fitvalue'=> $transfer * $sps->fitbanktransfers,      'type'=> 'Transferências', 'feetype'=> 'transferencia', 'totalvalue'=> $transfersum, 'show'=> 1]
                        ,
                        'billets' =>
                            ['quantity'=> $billets,       'fitvalue'=> $billets * $sps->fitbankbillets,         'type'=> 'Boletos',        'feetype'=> 'boleto',        'totalvalue'=> $billetssum, 'show'=> 1]
                        ,
                        'monthlyfee' =>
                            ['quantity'=> $monthlyfee,    'fitvalue'=> $sps->fitbankp2p,                        'type'=> 'Tarifa mensal',  'feetype'=> 'mensalidade',   'totalvalue'=> $monthlyfeesum, 'show'=> 1]
                        ,
                        'availablelimit' =>
                            ['quantity'=> $availablelimit,'fitvalue'=> $availablelimit * $sps->fitbankp2p,             'type'=> 'Adiantamento',   'feetype'=> 'p2p',           'totalvalue'=> $availablelimitsum, 'show'=> 1]
                        ,
                        'totalFitbank' => (
                                ($darf * $sps->fitbankpayments)+
                                ($darj * $sps->fitbankpayments)+
                                ($fgts * $sps->fitbankpayments)+
                                ($gps * $sps->fitbankpayments)+
                                ($gare * $sps->fitbankpayments)+
                                ($barcodepayment * $sps->fitbankpayments)+
                                ($transfer * $sps->fitbanktransfers)+
                                ($billets * $sps->fitbankbillets)+
                                ($availablelimit * $sps->fitbankp2p)
                            )
                        ,
                        'totalClientes' => ($transfersum + $billetssum + $monthlyfeesum + $availablelimitsum)
                    ];

        return $relatorio;
    }

    /*************************************************
    *
    * RELATORIOS SIMPLES
    *
    *
    */
    public static function relatoriosSimples($filtro) {

        $relatorio = [];

        $sps = getSPS();

        // darf
        $q_darf = Darfpayment::select('id')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('emission','>=',$filtro['datade'])
                            ->whereDate('emission','<=',$filtro['dataate']);

        $darf = $q_darf->count();

        // darj
        $q_darj = Darjpayment::select('id')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('emission','>=',$filtro['datade'])
                            ->whereDate('emission','<=',$filtro['dataate']);

        $darj = $q_darj->count();

        // fgts
        $q_fgts = Fgtspayment::select('id')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('emission','>=',$filtro['datade'])
                            ->whereDate('emission','<=',$filtro['dataate']);

        $fgts = $q_fgts->count();

        // gps
        $q_gps = Gpspayment::select('id')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('emission','>=',$filtro['datade'])
                            ->whereDate('emission','<=',$filtro['dataate']);

        $gps = $q_gps->count();

        // gare
        $q_gare = Garepayment::select('id')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('emission','>=',$filtro['datade'])
                            ->whereDate('emission','<=',$filtro['dataate']);

        $gare = $q_gare->count();

        // barcode
        $q_barcodepayment = Barcodepayment::select('id')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('emission','>=',$filtro['datade'])
                            ->whereDate('emission','<=',$filtro['dataate']);

        $barcodepayment = $q_barcodepayment->count();

        // transfer
        $q_transfer = Transferlog::select('id','ratevalue')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('actiondate','>=',$filtro['datade'])
                            ->whereDate('actiondate','<=',$filtro['dataate']);

        $c_transfer = clone $q_transfer;

        $transfer = $q_transfer->count();
        $transfersum = $c_transfer->sum('ratevalue');

        // billets
        $q_billets = Billet::select('id','ratevalue')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('emission','>=',$filtro['datade'])
                            ->whereDate('emission','<=',$filtro['dataate']);

        $c_billets = clone $q_billets;

        $billets = $q_billets->count();
        $billetssum = $c_billets->sum('ratevalue');

        // Usedavailablelimit
        $q_availablelimit = Usedavailablelimit::select('id','ratevalue')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('emission','>=',$filtro['datade'])
                            ->whereDate('emission','<=',$filtro['dataate']);

        $c_availablelimit = clone $q_availablelimit;

        $availablelimit = $q_availablelimit->count();
        $availablelimitsum = $c_availablelimit->sum('ratevalue');

        // MonthlyFeePayment
        $q_monthlyfee = MonthlyFeePayment::select('id','value')
                            ->where('client_id','=',$filtro['client_id'])
                            ->whereDate('paymentdate','>=',$filtro['datade'])
                            ->whereDate('paymentdate','<=',$filtro['dataate'])
                            ->where('status','=','1');

        $c_monthlyfee = clone $q_monthlyfee;

        $monthlyfee = $q_monthlyfee->count();
        $monthlyfeesum = $c_monthlyfee->sum('value');


        $relatorio = [
                        ['quantity'=> $darf,          'fitvalue'=> $darf * $sps->fitbankpayments,           'type'=> 'DARF',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1],
                        ['quantity'=> $darj,          'fitvalue'=> $darj * $sps->fitbankpayments,           'type'=> 'DARJ',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1],
                        ['quantity'=> $fgts,          'fitvalue'=> $fgts * $sps->fitbankpayments,           'type'=> 'FGTS',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1],
                        ['quantity'=> $gps,           'fitvalue'=> $gps * $sps->fitbankpayments,            'type'=> 'GPS',            'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1],
                        ['quantity'=> $gare,          'fitvalue'=> $gare * $sps->fitbankpayments,           'type'=> 'GARE',           'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1],
                        ['quantity'=> $barcodepayment,'fitvalue'=> $barcodepayment * $sps->fitbankpayments, 'type'=> 'Pagamentos',     'feetype'=> 'pagamento',     'totalvalue'=> 0, 'show'=> 1],
                        ['quantity'=> $transfer,      'fitvalue'=> $transfer * $sps->fitbanktransfers,      'type'=> 'Transferências', 'feetype'=> 'transferencia', 'totalvalue'=> $transfersum, 'show'=> 1],
                        ['quantity'=> $billets,       'fitvalue'=> $billets * $sps->fitbankbillets,         'type'=> 'Boletos',        'feetype'=> 'boleto',        'totalvalue'=> $billetssum, 'show'=> 1],
                        ['quantity'=> $monthlyfee,    'fitvalue'=> $sps->fitbankp2p,                        'type'=> 'Tarifa mensal',  'feetype'=> 'mensalidade',   'totalvalue'=> $monthlyfeesum, 'show'=> $filtro['mensalidade']],
                        ['quantity'=> $availablelimit,'fitvalue'=> $availablelimit * $sps->fitbankp2p,             'type'=> 'Adiantamento',   'feetype'=> 'p2p',           'totalvalue'=> $availablelimitsum, 'show'=> 1]
                ];

        return $relatorio;
    }


    public function exportXLS(Request $request) {

        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-3 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-01');
            $dataate = date('Y-m-d');
        }

        $filtroMensalidade = (isset($request) && $request->mensalidade != '')?$request->mensalidade:1;

        $q_listclients = Client::select('id','name')->orderBy('name','ASC');

        $client_id = (isset($request) && $request->client_id != '')?$request->client_id:0;

        return Excel::download(new ReportExport($datade, $dataate, $client_id, $filtroMensalidade), 'relatorioSimples.xlsx');
    }

    public function transferenciaVisaoGeral(Request $request) {

        $saldoSps = formatMoneyBr(getFitbankBalance());

        if($request->isMethod('post')) {
            $client = Client::where('id','=',$request->client_id)->first();

            $ultimasmovimentacoes = getLatestFinancesSmartsafe($client->id);

            // if(!$ultimasmovimentacoes) return redirect('/transferencia-visao-geral')->with('warning', 'Problema ao consultar. Se você nunca realizou transferência para esse cliente, primeiro deve fazer uma transferência.');

            return view('sps.transferenciavisaogeral',compact('client','ultimasmovimentacoes','saldoSps'));

        } else {
            $clients = Client::select('id','name','taxnumber')->where('active','=',1)->orderBy('name','ASC')->get();

            return view('sps.transferenciavisaogerallista',compact('clients','saldoSps'));
        }

    }

    public function provisionamento() {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

            $first = Client::select('id',
                                      'name',
                                      'taxnumber'
                                     );
            $clients = Multisafe::select('client_id as id',
                                        'nickname as name',
                                        'taxnumber'
                                       )->union($first)->orderBy('name','ASC')->get();
            return view('sps.provisionamento',compact('clients'));
    }

    public function ferramentas(Request $request) {
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

        $mensagem = '';

        if($request->isMethod('post')) {

            if($request->acao == 'utilizacaosaldo_calcularjuros') {

                \Artisan::call('command:availablelimitinterestcalculator');

                $first = Client::select('id',
                                          'name',
                                          'taxnumber'
                                         );
                $clients = Multisafe::select('client_id as id',
                                            'nickname as name',
                                            'taxnumber'
                                           )->union($first)->orderBy('name','ASC')->get();

                return view('sps.provisionamento',compact('clients'));
            }

            if($request->acao == 'utilizacaosaldo_cobrarjuros') {
                \Artisan::call('command:availablelimitinterestcharger');
            }

            return redirect('ferramentas')->with('success', 'Ação realizada');

        } else {


            return view('sps.ferramentas');
        }

    }



}
