<?php namespace App\Http\Controllers;

use App\Usedavailablelimit;
use DB;

use Illuminate\Http\Request;

class MonthlyFeePaymentController extends Controller
{

	public function ver(Request $request) {
// DB::enableQueryLog();
		$mesde = ($request->isMethod('post') && $request->mesde != '') ? $request->mesde : date('m');
		$anode = ($request->isMethod('post') && $request->anode != '') ? $request->anode : date('Y');

    	$mesate = ($request->isMethod('post') && $request->mesate != '') ? $request->mesate : date('m');
		$anoate = ($request->isMethod('post') && $request->anoate != '') ? $request->anoate : date('Y');

    	$q_mensalidades = Usedavailablelimit::leftJoin('clients','clients.id','=','usedavailablelimits.client_id')
            ->leftJoin('users','users.id','=','usedavailablelimits.user_id')
            ->where(function($query) use ($mesde, $anode) {
                    $query->whereMonth('usedavailablelimits.emission','>=', $mesde)
                            ->whereYear('usedavailablelimits.emission','>=',  $anode);
                })
            ->where(function($query) use ($mesate,$anoate) {
                    $query->whereMonth('usedavailablelimits.emission','<=', $mesate)
                            ->whereYear('usedavailablelimits.emission','<=',  $anoate);
                });


		if(isset($request) && $request->filtrostatus != '')
            $q_mensalidades->where('usedavailablelimits.paid','=',$request->filtrostatus);

		if(isset($request) && $request->filtrocliente != '')
            $q_mensalidades->where('usedavailablelimits.client_id','=',$request->filtrocliente);

		if(isset($request) && $request->filtroordem != '') {
            $q_mensalidades->orderBy($request->filtroordem,'asc');
		} else {
			$q_mensalidades->orderBy('clients.name','desc');
		}


		$mensalidades = $q_mensalidades->get();

        // dd($mensalidades);

		$filtrostatus  = (isset($request) && $request->filtrostatus != '')?$request->filtrostatus:'';
		$filtrocliente  = (isset($request) && $request->filtrocliente != '')?$request->filtrocliente:'';
		$filtroordem  = (isset($request) && $request->filtroordem != '')?$request->filtroordem:'';

		$filtro = [
				'mesde'=>$mesde,
				'anode'=>$anode,
				'mesate'=>$mesate,
				'anoate'=>$anoate,
				'filtrostatus'=>$filtrostatus,
				'filtrocliente'=>$filtrocliente,
				'filtroordem'=>$filtroordem
			];
// print "<br><br><br><br><br><br><br><br><pre>";
// print_r( DB::getQueryLog());
// print "</pre>";
		return view('sps.mensalidadesVer',compact('mensalidades','filtro'));

	}


	public function editar(Request $request) {
		$mensalidade = MonthlyFeePayment::select('id','duedate','value','details')->where('id','=',$request->id)->first();

		$mensalidade->duedate = date2us($request->newduedate);
		$mensalidade->value = covert2Float($request->newvalue);
		$mensalidade->details = $request->details;

		$mensalidade->update();

		if(!$mensalidade) return redirect('/mensalidades/ver')->with('warning','Houve um erro ao atualizar. Por favor tente mais tarde.');

		return redirect('/mensalidades/ver')->with('success','Informações de pagamento atualizadas.');
	}

}
