<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Client;
use App\User;
use App\Moneytransfer;

class MoneytransferController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
	* moneytransferFormulario
    */
	public function moneytransferFormulario() {
    	$client = getClientById(Auth::user()->client_id);

    	return view('clients.moneytransferForm',compact('client'));
    }

    /**
	* moneytransferEnviar
    */
    public function moneytransferEnviar(Request $request) {

    	$client = getClientById(Auth::user()->client_id);

        $spsInfo = getSPS();
    	
    	$curlParams = "{ \"Method\": \"GeneratePaymentDARF\",
    				\"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
    				\"TaxNumber\": \"".somenteNumeros($request->taxnumber)."\",
    				\"DARFType\": ".$request->moneytransfertype.",
				    \"CalculationPeriod\": \"".dataSlashReverse($request->calculationperiod)."\",
				    \"CodeRevenue\": \"".$request->coderevenue."\",
				    \"ContributorTaxNumber\": \"".somenteNumeros($request->contributortaxnumber)."\",
				    \"ReferenceNumber\": \"".$request->referencenumber."\",
				    \"DueDate\": \"".dataSlashReverse($request->duedate)."\",
				    \"GrossRevenueValue\": ".covert2Float($request->grossrevenuevalue).",
				    \"GrossRevenuePercentage\": ".covert2Float($request->grossrevenuepercentage).",

				    \"PrincipalValue\": ".covert2Float($request->principalvalue).",
				    \"FineValue\": ".covert2Float($request->finevalue).",
				    \"InterestValue\": ".covert2Float($request->interestvalue).",
				    \"TotalValue\": ".covert2Float($request->totalvalue).",
				    \"PaymentDate\": \"".dataSlashReverse($request->paymentdate)."\",
				    \"Tags\": [],
				    \"Description\": \"".$request->description."\",
				    \"Identifier\": \"".concatIdentifier($request->identifier)."\",
				    \"RateValueType\": 1
    			}";

    	$enviar = sendCurl($curlParams);

    	if($enviar["Success"] == "false") {
    		$validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
    		$mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
    		saveTransferErrorLog('GeneratePaymentDARF', $curlParams, $mensagem, $validacao);

    		return redirect('/moneytransfer')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
    	}

    	$documentnumber = (isset($enviar['DocumentNumber']))?$enviar['DocumentNumber']:'0';
    	$alreadyexists = (isset($enviar['AlreadyExists']))?1:0;

    	$checkDocnumber = $this->checkExists($documentnumber);
    	if(!$checkDocnumber) {
    		$viewStatus = 'status';
    		$viewMessage = 'Documento enviado.';
    		$this->saveMoneytransferLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$alreadyexists);
    	} else {
    		$viewStatus = 'danger';
    		$viewMessage = 'O documento já foi enviado anteriormente!';
    	}

    	return view('clients.moneytransferEnviado',compact('enviar'))->with($viewStatus,$viewMessage);
    }

    /**
	* moneytransferListar
    */

    public function moneytransferConsultar(Request $request) {
		$client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();
		
		if ($request->isMethod('post') && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate )) {
			$datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
    		$dataate = date(dataSlashReverse($request->dataate));    		
    	} else {
    		$datade  = date('Y/m/d', strtotime('-15 days'));
    		$dataate = date('Y/m/d');	
    	}

    	$moneytransfers = Moneytransfer::where('taxnumber','=',$request->taxnumber)
							->whereDate('emission','>=',$datade)
							->whereDate('emission','<=',$dataate)
							->orderBy('created_at','desc')
							->get();

		$datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate));

		return view('clients.moneytransferConsultar',compact('moneytransfers','datafiltro'));
	}

	public function checkExists($docnumber) {
		$check = Moneytransfer::where('documentnumber','=',$docnumber)->first();
		return (!$check)?false:true;
	}


    /* ******************  LOGS  ****************** */

    public function saveMoneytransferLog($taxnumber, $request, $curlParams,$documentnumber,$alreadyexists) {

		$userInfo = Auth::user();

		$logerror = new Moneytransfer();
		$logerror->user_id = $userInfo->id;
		$logerror->client_id = $userInfo->client_id;
		$logerror->taxnumber = $taxnumber;
		$logerror->emission = date('Y-m-d H:i:s');
		$logerror->moneytransfertype = $request->darftype;
		$logerror->calculationperiod = dataSlashReverse($request->calculationperiod);
		$logerror->coderevenue = $request->coderevenue;
		$logerror->contributortaxnumber = somenteNumeros($request->contributortaxnumber);
		$logerror->referencenumber = $request->referencenumber;
		$logerror->duedate = dataSlashReverse($request->duedate);
		$logerror->grossrevenuevalue = covert2Float($request->grossrevenuevalue);
		$logerror->grossrevenuepercentage = covert2Float($request->grossrevenuepercentage);
		$logerror->principalvalue = covert2Float($request->principalvalue);
		$logerror->finevalue = covert2Float($request->finevalue);
		$logerror->interestvalue = covert2Float($request->interestvalue);
		$logerror->totalvalue = covert2Float($request->totalvalue);
		$logerror->paymentdate = dataSlashReverse($request->paymentdate);
		$logerror->description = $request->description;
		$logerror->identifier = concatIdentifier($request->identifier);
		$logerror->ratevaluetype = 1;
		$logerror->status = 0;
		$logerror->documentnumber = $documentnumber;
		$logerror->alreadyexists = $alreadyexists;
		$logerror->datasent = $curlParams;
		$logerror->save();

		return true;
	}

	
	

	

	public function moneytransferCancelar() {
        $spsInfo = getSPS();
        // todo: finalizar
		// $curlParams = "{ \"Method\": \"CancelPaymentDARF\",
  //   				\"PartnerId\": ".$spsInfo->partnerid.",
//                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
  //   				\"DocumentNumber\": \"".$docnumber."\"
  //   			}";

  //   	$enviar = sendCurl($curlParams);

  //   	if($enviar["Success"] == "false") {
  //   		$validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
  //   		$mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
  //   		saveTransferErrorLog('CancelPaymentDARF', $curlParams, $mensagem, $validacao);

  //   		return redirect('/moneytransfer')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
  //   	}


    	
	}

}
