<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


use App\LogsCurl;
use App\Client;

class LogController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    private function obtemDataFiltro(Request $request)
    {
        if(isset($request) && $request->dataDe != ''  && $request->dataAte != '' && ( $request->dataDe <= $request->dataAte ) ) {
            $dataDe  = date(date2us($request->dataDe), strtotime('-0 days'));
            $dataAte = date(date2us($request->dataAte));            
        } else {
            $dataDe  = date('Y-m-d', strtotime('-0 days'));
            $dataAte = date('Y-m-d');   
        }

        $filtroCliente = (isset($request) && $request->client_id != '')?$request->client_id:'';
        $filtroMetodo  = (isset($request) && $request->method != '')?$request->method:'';

    	$dataFiltro = array(
    		'dataDe'=>dataSlashReverse($dataDe),
    	 	'dataAte'=>dataSlashReverse($dataAte),
    	 	'filtroCliente'=>$filtroCliente,
    	 	'filtroMetodo'=>$filtroMetodo
    	 );
    	return $dataFiltro;
    }

    public function transacoesfit(Request $request) 
    {
        
        if(Auth::user()->role_id>1) return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');

		$datafiltro = $this->obtemDataFiltro($request);
		$clients = Client::select('id','name')->orderBy('name','ASC')->get();

		if(isset($request) && $request->dataDe == ''  && $request->dataAte == '') {
			$erros = $tlogs = LogsCurl::where('id','=',0);
			return view('logs.transacoesfit',compact('erros','datafiltro','clients'));
		}

		//whereNull
        $tlogs = LogsCurl::select(  'logscurl.id',
                                    'logscurl.success',
                                    'logscurl.sentdate as transactiondate',
                                    'logscurl.datasent',
                                    'logscurl.datareceived',
                                    'logscurl.message',
                                    'logscurl.validation',
                                    'logscurl.documentnumber',
                                    'clients.name as client',
                                    'users.name'
                            )
                            ->leftjoin('clients','clients.id','=','logscurl.client_id')
                            ->join('users','users.id','=','logscurl.user_id')
                            ->whereDate('logscurl.sentdate','>=',$datafiltro['dataDe'])
                            ->whereDate('logscurl.sentdate','<=',$datafiltro['dataAte']);
        
        $sucesso = $request->sucesso;
        if(isset($request) && $sucesso == '0') {
			$tlogs->where(
				function ($query) use ($sucesso) {
					return $query->whereNull('logscurl.success')
					->orWhere('logscurl.success', '=', $sucesso);
				}
			);
        } else if(isset($request) && $sucesso == '1') {
        	$tlogs->where('logscurl.success','=',$sucesso);
        }

        // if(isset($request) && $request->method != '') {
        // 	$tlogs->where('transfererrorlogs.method','=',$request->method);
        // }

        if(isset($request) && $request->client_id != '')
            $tlogs->where('logscurl.client_id','=',$request->client_id);

        
        $erros = $tlogs->orderBy('logscurl.sentdate','desc')->get();

        //$datafiltro = array('dataDe'=>dataSlashReverse($dataDe),'dataAte'=>dataSlashReverse($dataAte),'filtroCliente'=>$filtroCliente,'filtroMetodo'=>$filtroMetodo);     

        return view('logs.transacoesfit',compact('erros','datafiltro','clients'));
    }

}
