<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Client;
use App\Multisafe;

use Illuminate\Support\Facades\Session;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        if (Auth::user()->role_id == 1) return redirect('/spsinfo');

        $client = Client::select('id','taxnumber','allowlimit','availablelimit')->where('id','=',Auth::user()->client_id)->first();

        if(!$client) {
            Auth::logout();
            return redirect('login')->with('warning','Cliente não encontrado. Entre em contato com o suporte.');
        }

        $datade  = date('Y/m/d', strtotime('-7 days'));
        $dataate = date('Y/m/d');   

        $spsInfo = getSPS();

        $client_taxnumber = Session::get('cnpj');

        $curlParams = "{ \"Method\": \"GetAccountEntry\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".$client_taxnumber."\",
                    \"StartDate\": \"".$datade."\",
                    \"EndDate\": \"".$dataate."\"
                }";

        $extrato = sendCurl($curlParams);
        $msg = false;
        // if($extrato["Success"] == "false") return redirect('/home')->with('warning', 'Erro: ocorreu um problema ao processar a requisição.');
        if($extrato["Success"] == "false") { $extrato = false; $msg = 'Ocorreu um problema ao processar a requisição.'; }
        
        // $saldocompensar = getSmartsafeBalance($client->id);
        $clientMultiCnpj = getMultiCnpj($client->id);
        $clientMultiCnpjAvailableLimit = getAvailableLimitMultiCnpj($client_taxnumber);

        $saldocompensar = (empty($clientMultiCnpj))? $client->availablelimit : $clientMultiCnpjAvailableLimit;

        return view('home',compact('extrato','client','saldocompensar'))->with('warning',$msg);
    }

    public function logout()
    {
        Auth::logout();

        return redirect('login');
    }
}
