<?php

namespace App\Http\Controllers;

use App\Classes\ClientSPS\ClientSpsService;
use Illuminate\Http\Request;
use App\Client;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

class HomeApiController extends Controller
{
    public function index(Request $request)
    {
        $isAuth = $this->checkAuth();

        $request->validate([
            'taxnumber' => ['required', 'max:14', 'min:11'],
        ], [
            'taxnumber.required' => 'O CNPJ é obrigatório.',
            'taxnumber.max' => 'Utilize apenas números para informar o CNPJ e não ultrapasse 14 caracteres.',
            'taxnumber.min' => 'Utilize apenas números para informar o CNPJ e não ultrapasse 14 caracteres.',
        ]);

        $userInfo = JWTAuth::user();

        $spsInfo = getSPS();

        try {
            $client = new ClientSpsService($request->taxnumber);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'CNPJ não encontrado.',
            ]);
        }

        if ($client->clientId !== $userInfo->client_id) {
            return response()->json([
                'success' => false,
                'message' => 'Você não possui permissão para acessar este CNPJ.',
            ], 403);
        }

//        $client = Client::select('taxnumber','allowlimit','availablelimit')->where('id','=',$userInfo->client_id)->first();

        if(!$client) return response()->json(
            [
                "success" => false,
                "message" =>"Cliente não encontrado. Entre em contato com o suporte."
            ]
        );

        $datade  = date('Y/m/d', strtotime('-7 days'));
        $dataate = date('Y/m/d');

        $curlParams = "{ \"Method\": \"GetAccountEntry\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".$client->taxnumber."\",
                    \"StartDate\": \"".$datade."\",
                    \"EndDate\": \"".$dataate."\"
                }";

        $extrato = sendCurl($curlParams);
        $msg = false;
        // if($extrato["Success"] == "false") return redirect('/home')->with('warning', 'Erro: ocorreu um problema ao processar a requisição.');
        if($extrato["Success"] == "false") { $extrato = false; $msg = 'Ocorreu um problema ao processar a requisição.'; }

        return response()->json(
            [
                "success" => true,
                "data" =>[
                            "saldo" => number_format($extrato['Balance'],2,',','.'),
                            "saldocompensar" => number_format($client->availablelimit,2,',','.'),
                            "disponivel" => number_format(($extrato['Balance']+$client->availablelimit),2,',','.'),
                        ],
            ]
        );
    }

    public function checkAuth()
    {
        try {

            if (! $user = JWTAuth::parseToken()->authenticate()) {
                    return response()->json(['user_not_found'], 404);
            }

        } catch (Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {

                return response()->json(['token_expired'], $e->getStatusCode());

        } catch (Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {

                return response()->json(['token_invalid'], $e->getStatusCode());

        } catch (Tymon\JWTAuth\Exceptions\JWTException $e) {

                return response()->json(['token_absent'], $e->getStatusCode());

        }

        return true;
    }
}
