<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Client;
use App\User;
use App\Gpspayment;

class GpspaymentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
    * gpsFormulario
    */
    public function gpsFormulario() {
        $client = getClientById(Auth::user()->client_id);

        return view('clients.gpsForm',compact('client'));
    }

    /**
    * gpsEnviar
    */
    public function gpsEnviar(Request $request) {
// TODO ratevalue
        $client = getClientById(Auth::user()->client_id);

        $spsInfo = getSPS();

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($client->taxnumber);
        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        $valor = covert2Float($request->totalvalue);
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        $cli_ratevalue = consultaTaxaCliente($client->id, 'payment', covert2Float($request->principalvalue));

        // verifica se o disponível é >= valor a ser transferido
        if($valor > $saldoCliente) {
            // se não for, verifica se permite usar saldo a compensar
            if(isset($request->limiteespecial) && $request->limiteespecial == 1) {

                // saldo a transferir para completar o pagamento
                $saldoATransferir = ($valor - $saldoCliente);

                // ao saldo a transferir deve ser adicionada a taxa
                $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $saldoATransferir);

                // verifica se o cliente possui saldo a compensar suficiente
                if( ($saldoCliente + $saldoDisponivel) < ($valor + $cashbackvalue + $cli_ratevalue) ) {
                    return redirect('gps')->with('warning', 'Não há saldo suficiente para realizar a operação.');
                } else {
                    // realiza a transferencia do valor adicional para o cliente
                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, ( $saldoATransferir + $cashbackvalue), 'Transferencia de saldo a compensar', $cashbackvalue, $cli_ratevalue);

                    if(!$transfereSaldoDisponivel) return redirect('gps')->with('warning', 'Ocorreu um erro ao realizar a operação. Por favor tente mais tarde.');

                    // $logLimitUsed = logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARF', '0', false); // salva detalhamento
                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoATransferir;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            } else {
                return redirect('gps')->with('warning', 'Não há saldo suficiente para realizar a operação.');
            }
        }
        // /CONSULTA O SALDO DO CLIENTE
            
        $newIdentifier = concatIdentifier($request->identifier);

        

        $curlParams = "{ \"Method\": \"GeneratePaymentGPS\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".somenteNumeros($request->taxnumber)."\",
                    \"ContributorTaxNumber\": \"".somenteNumeros($request->contributortaxnumber)."\",
                    \"PrincipalValue\": ".covert2Float($request->principalvalue).",
                    \"FineInterestValue\": ".covert2Float($request->fineinterestvalue).",
                    \"OtherValues\": ".covert2Float($request->othervalues).",
                    \"RateValue\": \"".$cli_ratevalue."\",
                    \"PaymentDate\": \"".dataSlashReverse($request->paymentdate)."\",
                    \"DueDate\": \"".dataSlashReverse($request->duedate)."\",
                    \"Tags\": [],
                    \"RateValueType\": \"1\",
                    \"Description\": \"".$request->description."\",
                    \"Identifier\": \"".$newIdentifier."\",
                    \"PaymentCode\": \"".$request->paymentcode."\",
                    \"ReferenceNumber\": \"".somenteNumeros($request->referencenumber)."\",
                    \"JurisdictionDate\": \"".somenteNumeros($request->jurisdictiondate)."\"
                }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('GeneratePaymentGPS', $curlParams, $mensagem, $validacao);

            return redirect('/gps')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
        }

        $documentnumber = (isset($enviar['DocumentNumber']))?$enviar['DocumentNumber']:'0';
        $alreadyexists = (isset($enviar['AlreadyExists']))?1:0;

        $checkDocnumber = $this->checkExists($documentnumber);
        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Documento enviado.';
            $this->saveGpsLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$alreadyexists, 0, $newIdentifier,$saldoCompensar,$saldoCompensarValor);

            if($logLimitUsed) logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'GPS', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento
        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }

        return view('clients.gpsEnviado',compact('enviar'))->with($viewStatus,$viewMessage);
    }

    /**
    * gpsListar
    */

    public function gpsConsultar(Request $request) {
        $client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();
        
        if ($request->isMethod('post') && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate )) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));           
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');   
        }

        $q_gpss = Gpspayment::where('taxnumber','=',$request->taxnumber)
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

        if(isset($request) && $request->filtrostatus != '')
            $q_gpss->where('status','=',$request->filtrostatus);


        $gpss = $q_gpss->orderBy('created_at','desc')->get();

        $filtrostatus  = (isset($request) && $request->filtrostatus != '')?$request->filtrostatus:'';

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate), 'filtrostatus'=>$filtrostatus);

        return view('clients.gpsConsultar',compact('gpss','datafiltro'));
    }

    public function checkExists($docnumber) {
        $check = Gpspayment::where('documentnumber','=',$docnumber)->first();
        return (!$check)?false:true;
    }


    /* ******************  LOGS  ****************** */

    public function saveGpsLog($taxnumber, $request, $curlParams,$documentnumber,$alreadyexists,$ratevalue, $newIdentifier, $saldoCompensar,$saldoCompensarValor) {

        $userInfo = Auth::user();

        $logerror = new Gpspayment();
        $logerror->user_id = $userInfo->id;
        $logerror->client_id = $userInfo->client_id;
        $logerror->taxnumber = $taxnumber;
        $logerror->emission = date('Y-m-d H:i:s');
        $logerror->contributortaxnumber = somenteNumeros($request->contributortaxnumber);
        $logerror->principalvalue = covert2Float($request->principalvalue);
        $logerror->fineinterestvalue = covert2Float($request->fineinterestvalue);
        $logerror->othervalues = covert2Float($request->othervalues);
        $logerror->ratevalue = covert2Float($request->ratevalue);
        $logerror->paymentdate = date2us($request->paymentdate);
        $logerror->ratevaluetype = $request->ratevaluetype;
        $logerror->description = $request->description;
        $logerror->identifier = $newIdentifier;
        $logerror->ratevalue = $ratevalue;
        $logerror->paymentcode = $request->paymentcode;
        $logerror->referencenumber = $request->referencenumber;
        $logerror->jurisdictiondate = $request->jurisdictiondate;
        $logerror->status = 0;
        $logerror->documentnumber = $documentnumber;
        $logerror->alreadyexists = $alreadyexists;
        $logerror->datasent = $curlParams;
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
        $logerror->save();

// \"RateValue\": 4;

        return true;
    }

    
    public function gpsCancelar() {
        $spsInfo = getSPS();
        // TODO terminar este método
        $curlParams = "{ \"Method\": \"CancelPaymentGps\",
                \"PartnerId\": ".$spsInfo->partnerid.",
                \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                \"DocumentNumber\": \"".$docnumber."\"
             }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('CancelPaymentGps', $curlParams, $mensagem, $validacao);

         return redirect('/gps')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
        }


        
    }

}
