<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Client;
use App\User;
use App\Fgtspayment;

class FgtspaymentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
    * fgtsFormulario
    */
    public function fgtsFormulario() {
        $client = getClientById(Auth::user()->client_id);

        return view('clients.fgtsForm',compact('client'));
    }

    /**
    * fgtsEnviar
    */
    public function fgtsEnviar(Request $request) {
// TODO ratevalue
        $client = getClientById(Auth::user()->client_id);

        $spsInfo = getSPS();

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($client->taxnumber);
        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        $valor = covert2Float($request->principalvalue);
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        // verifica se o disponível é >= valor a ser transferido
        if($valor > $saldoCliente) {
            // se não for, verifica se permite usar saldo a compensar
            if(isset($request->limiteespecial) && $request->limiteespecial == 1) {

                // saldo a transferir para completar o pagamento
                $saldoATransferir = ($valor - $saldoCliente);

                // ao saldo a transferir deve ser adicionada a taxa
                $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $saldoATransferir);

                // verifica se o cliente possui saldo a compensar suficiente
                if( ($saldoCliente + $saldoDisponivel) < ($valor + $cashbackvalue) ) {
                    return redirect('fgts')->with('warning', 'Não há saldo suficiente para realizar a operação.');
                } else {
                    // realiza a transferencia do valor adicional para o cliente
                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, ( $saldoATransferir + $cashbackvalue), 'Transferencia de saldo a compensar', $cashbackvalue);

                    if(!$transfereSaldoDisponivel) return redirect('fgts')->with('warning', 'Ocorreu um erro ao realizar a operação. Por favor tente mais tarde.');

                    // $logLimitUsed = logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARF', '0', false); // salva detalhamento
                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoATransferir;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            } else {
                return redirect('fgts')->with('warning', 'Não há saldo suficiente para realizar a operação.');
            }
        }
        // /CONSULTA O SALDO DO CLIENTE

        $newIdentifier = concatIdentifier($request->identifier);

        $curlParams = "{ \"Method\": \"GeneratePaymentFGTS\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".somenteNumeros($request->taxnumber)."\",
                    \"ContributorTaxNumber\": \"".somenteNumeros($request->contributortaxnumber)."\",
                    \"PrincipalValue\": ".covert2Float($request->principalvalue).",
                    \"CodeRevenue\": \"".$request->coderevenue."\",
                    \"Barcode\": \"".somenteNumeros($request->barcode)."\",
                    \"FgtsIdentifier\": \"".$request->fgtsidentifier."\",
                    \"SocialConnectivityCode\": \"".$request->socialconnectivitycode."\",
                    \"SocialConnectivityDigit\": \"".$request->socialconnectivitydigit."\",
                    \"PaymentDate\": \"".dataSlashReverse($request->paymentdate)."\",
                    \"Tags\": [],
                    \"RateValueType\": \"1\",
                    \"Description\": \"".$request->description."\",
                    \"Identifier\": \"".$newIdentifier."\"
                }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('GeneratePaymentFGTS', $curlParams, $mensagem, $validacao);

            return redirect('/fgts')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
        }

        $documentnumber = (isset($enviar['DocumentNumber']))?$enviar['DocumentNumber']:'0';
        $alreadyexists = (isset($enviar['AlreadyExists']))?1:0;

        $checkDocnumber = $this->checkExists($documentnumber);
        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Documento enviado.';
            $this->saveFgtsLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$alreadyexists, 0, $newIdentifier,$saldoCompensar,$saldoCompensarValor);

            if($logLimitUsed) logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'FGTS', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento
        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }

        return view('clients.fgtsEnviado',compact('enviar'))->with($viewStatus,$viewMessage);
    }

    /**
    * fgtsListar
    */

    public function fgtsConsultar(Request $request) {
        $client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();
        
        if ($request->isMethod('post') && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate )) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));           
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');   
        }

        $q_fgtss = Fgtspayment::where('taxnumber','=',$request->taxnumber)
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

        if(isset($request) && $request->filtrostatus != '')
            $q_fgtss->where('status','=',$request->filtrostatus);


        $fgtss = $q_fgtss->orderBy('created_at','desc')->get();

        $filtrostatus  = (isset($request) && $request->filtrostatus != '')?$request->filtrostatus:'';

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate), 'filtrostatus'=>$filtrostatus);

        return view('clients.fgtsConsultar',compact('fgtss','datafiltro'));
    }

    public function checkExists($docnumber) {
        $check = Fgtspayment::where('documentnumber','=',$docnumber)->first();
        return (!$check)?false:true;
    }


    /* ******************  LOGS  ****************** */

    public function saveFgtsLog($taxnumber, $request, $curlParams,$documentnumber,$alreadyexists,$ratevalue, $newIdentifier, $saldoCompensar,$saldoCompensarValor) {

        $userInfo = Auth::user();

        $logerror = new Fgtspayment();
        $logerror->user_id = $userInfo->id;
        $logerror->client_id = $userInfo->client_id;
        $logerror->taxnumber = $taxnumber;
        $logerror->emission = date('Y-m-d H:i:s');
        $logerror->contributortaxnumber = somenteNumeros($request->contributortaxnumber);
        $logerror->principalvalue = covert2Float($request->principalvalue);
        $logerror->coderevenue = $request->coderevenue;
        $logerror->barcode = $request->barcode;
        $logerror->fgtsidentifier = $request->fgtsidentifier;
        $logerror->socialconnectivitycode = $request->socialconnectivitycode;
        $logerror->socialconnectivitydigit = $request->socialconnectivitydigit;
        $logerror->paymentdate = date2us($request->paymentdate);
        $logerror->description = $request->description;
        $logerror->identifier = $newIdentifier;
        $logerror->ratevalue = $ratevalue;
        $logerror->status = 0;
        $logerror->documentnumber = $documentnumber;
        $logerror->alreadyexists = $alreadyexists;
        $logerror->datasent = $curlParams;
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
        $logerror->save();

// \"RateValue\": 4;

        return true;
    }

    
    public function fgtsCancelar() {
        $spsInfo = getSPS();
        // TODO terminar este método
        $curlParams = "{ \"Method\": \"CancelPaymentFGTS\",
                \"PartnerId\": ".$spsInfo->partnerid.",
                \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                \"DocumentNumber\": \"".$docnumber."\"
             }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('CancelPaymentFGTS', $curlParams, $mensagem, $validacao);

         return redirect('/fgts')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
        }


        
    }

}
