<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Client;
use App\User;
use App\Darjpayment;

class DarjpaymentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
    * darjFormulario
    */
    public function darjFormulario() {
        $client = getClientById(Auth::user()->client_id);

        return view('clients.darjForm',compact('client'));
    }

    /**
    * darjEnviar
    */
    public function darjEnviar(Request $request) {
// TODO ratevalue
        $client = getClientById(Auth::user()->client_id);

        $spsInfo = getSPS();

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($client->taxnumber);
        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        $valor = covert2Float($request->totalvalue);
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        $cli_ratevalue = consultaTaxaCliente($client->id, 'payment', covert2Float($request->totalvalue));

        // verifica se o disponível é >= valor a ser transferido
        if($valor > $saldoCliente) {
            // se não for, verifica se permite usar saldo a compensar
            if(isset($request->limiteespecial) && $request->limiteespecial == 1) {

                // saldo a transferir para completar o pagamento
                $saldoATransferir = ($valor - $saldoCliente);

                // ao saldo a transferir deve ser adicionada a taxa
                $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $saldoATransferir);

                // verifica se o cliente possui saldo a compensar suficiente
                if( ($saldoCliente + $saldoDisponivel) < ($valor + $cashbackvalue + $cli_ratevalue) ) {
                    return redirect('darj')->with('warning', 'Não há saldo suficiente para realizar a operação.');
                } else {
                    // realiza a transferencia do valor adicional para o cliente
                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, ( $saldoATransferir + $cashbackvalue), 'Transferencia de saldo a compensar', $cashbackvalue, $cli_ratevalue);

                    if(!$transfereSaldoDisponivel) return redirect('darj')->with('warning', 'Ocorreu um erro ao realizar a operação. Por favor tente mais tarde.');

                    // $logLimitUsed = logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARF', '0', false); // salva detalhamento
                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoATransferir;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            } else {
                return redirect('darj')->with('warning', 'Não há saldo suficiente para realizar a operação.');
            }
        }
        // /CONSULTA O SALDO DO CLIENTE

        $newIdentifier = concatIdentifier($request->identifier);

        

        $curlParams = "{ \"Method\": \"GeneratePaymentDARJ\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".somenteNumeros($request->taxnumber)."\",
                    \"ContributorTaxNumber\": \"".somenteNumeros($request->contributortaxnumber)."\",
                    \"ReferenceNumber\": \"".$request->referencenumber."\",
                    \"PrincipalValue\": ".covert2Float($request->principalvalue).",
                    \"FineValue\": ".covert2Float($request->finevalue).",
                    \"InterestValue\": ".covert2Float($request->interestvalue).",
                    \"MonetaryValue\": ".covert2Float($request->monetaryvalue).",
                    \"TotalValue\": ".covert2Float($request->totalvalue).",
                    \"RateValue\": \"".$cli_ratevalue."\",
                    \"DueDate\": \"".dataSlashReverse($request->duedate)."\",
                    \"PaymentDate\": \"".dataSlashReverse($request->paymentdate)."\",
                    \"Tags\": [],
                    \"CodeRevenue\": \"".$request->coderevenue."\",
                    \"StateRegistration\": \"".somenteNumeros($request->stateregistration)."\",
                    \"Description\": \"".$request->description."\",
                    \"Identifier\": \"".$newIdentifier."\"
                }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('GeneratePaymentDARJ', $curlParams, $mensagem, $validacao);

            return redirect('/darj')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
        }

        $documentnumber = (isset($enviar['DocumentNumber']))?$enviar['DocumentNumber']:'0';
        $alreadyexists = (isset($enviar['AlreadyExists']))?1:0;

        $checkDocnumber = $this->checkExists($documentnumber);
        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Documento enviado.';
            $this->saveDarjLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$alreadyexists, 0, $newIdentifier,$saldoCompensar,$saldoCompensarValor);

            if($logLimitUsed) logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARJ', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento
        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }

        return view('clients.darjEnviado',compact('enviar'))->with($viewStatus,$viewMessage);
    }

    /**
    * darjListar
    */

    public function darjConsultar(Request $request) {
        $client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();
        
        if ($request->isMethod('post') && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate )) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));           
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');   
        }

        $q_darjs = Darjpayment::where('taxnumber','=',$request->taxnumber)
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

        if(isset($request) && $request->filtrostatus != '')
            $q_darjs->where('status','=',$request->filtrostatus);

        $darjs = $q_darjs->orderBy('created_at','desc')->get();

        $filtrostatus  = (isset($request) && $request->filtrostatus != '')?$request->filtrostatus:'';

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate), 'filtrostatus'=>$filtrostatus);

        return view('clients.darjConsultar',compact('darjs','datafiltro'));
    }

    public function checkExists($docnumber) {
        $check = Darjpayment::where('documentnumber','=',$docnumber)->first();
        return (!$check)?false:true;
    }


    /* ******************  LOGS  ****************** */

    public function saveDarjLog($taxnumber, $request, $curlParams,$documentnumber,$alreadyexists,$ratevalue,$newIdentifier,$saldoCompensar,$saldoCompensarValor) {

        $userInfo = Auth::user();

        $logerror = new Darjpayment();
        $logerror->user_id = $userInfo->id;
        $logerror->client_id = $userInfo->client_id;
        $logerror->taxnumber = $taxnumber;
        $logerror->emission = date('Y-m-d H:i:s');
        $logerror->contributortaxnumber = somenteNumeros($request->contributortaxnumber);
        $logerror->referencenumber = $request->referencenumber;
        $logerror->principalvalue = covert2Float($request->principalvalue);
        $logerror->finevalue = covert2Float($request->finevalue);
        $logerror->interestvalue = covert2Float($request->interestvalue);
        $logerror->monetaryvalue = covert2Float($request->monetaryvalue);
        $logerror->totalvalue = covert2Float($request->totalvalue);
        $logerror->duedate = dataSlashReverse($request->duedate);
        $logerror->paymentdate = date2us($request->paymentdate);
        $logerror->coderevenue = $request->coderevenue;
        $logerror->stateregistration = somenteNumeros($request->stateregistration);
        $logerror->description = $request->description;
        $logerror->identifier = $newIdentifier;
        $logerror->ratevalue = $ratevalue;
        $logerror->status = 0;
        $logerror->documentnumber = $documentnumber;
        $logerror->alreadyexists = $alreadyexists;
        $logerror->datasent = $curlParams;
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
        $logerror->save();

// \"RateValue\": 4;

        return true;
    }

    
    

    

    public function darjCancelar() {
        $spsInfo = getSPS();
        // TODO terminar este método
        $curlParams = "{ \"Method\": \"CancelPaymentDARJ\",
                \"PartnerId\": ".$spsInfo->partnerid.",
                \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                \"DocumentNumber\": \"".$docnumber."\"
             }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('CancelPaymentDARJ', $curlParams, $mensagem, $validacao);

         return redirect('/darj')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
        }


        
    }

}
