<?php namespace App\Http\Controllers;

use App\Clientcontact;
use App\Smartsafetransfer;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;

use Validator;

class ClientcontactController extends Controller
{

	public function contatos()
	{
        $userInfo = JWTAuth::user();

        $clients = Clientcontact::where('client_id','=',$userInfo->client_id)->orderBy('customername','asc')->get();
		$status=(!$clients)?false:true;

        $contatos = [];

        foreach($clients as $cli) {
                $infobancarias = '';
                if(!empty($cli->bank)) {
                    $infobancarias .= '('. $cli->bank 
                                    .' '. replaceNullValueWithEmptyString($cli->bankaccount) 
                                    .' '. replaceNullValueWithEmptyString($cli->bankaccountdigito) .')';
                }


                $contatos[] = [
                        'client_id' => $cli->client_id,
                        'customername' => $cli->customername,
                        'customertaxnumber' => formataCNPJ($cli->customertaxnumber),
                        'customermail' => $cli->customermail,
                        'customerphone' => $cli->customerphone,
                        'customerphoneformatted' => formataTelefone($cli->customerphone),
                        'addressline1' => replaceNullValueWithEmptyString($cli->addressline1),
                        'addressline2' => replaceNullValueWithEmptyString($cli->addressline2),
                        'neighborhood' => replaceNullValueWithEmptyString($cli->neighborhood),
                        'city' => replaceNullValueWithEmptyString($cli->city),
                        'state' => replaceNullValueWithEmptyString($cli->state),
                        'zipcode' => replaceNullValueWithEmptyString($cli->zipcode),
                        'bankcode' => replaceNullValueWithEmptyString($cli->bankcode),
                        'bank' => replaceNullValueWithEmptyString($cli->bank),
                        'bankbranch' => replaceNullValueWithEmptyString($cli->bankbranch),
                        'bankaccount' => replaceNullValueWithEmptyString($cli->bankaccount),
                        'bankaccountdigito' => replaceNullValueWithEmptyString($cli->bankaccountdigito),
                        'infobancarias' => $infobancarias
                ];

        }


		return response()->json(['success'=>$status,"data" => ["contatos" => $contatos]]);
	}
	

    public function criar(Request $request)
    {
        $userInfo = JWTAuth::user();

        $validator = Validator::make($request->all(), [
            'customername' => 'required',
            'customertaxnumber' => 'required',
            'customermail' => 'required',
            'customerphone' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Preencha os campos obrigatórios.'
            ]);
        }

        if ($request->isMethod('post')) {
            $contact = new Clientcontact();

            $contact->client_id = $userInfo->client_id;
            $contact->customername = $request->customername;
            $contact->customertaxnumber = somenteNumeros($request->customertaxnumber);
            $contact->customermail = $request->customermail;
            $contact->customerphone = somenteNumeros($request->customerphone);
            $contact->addressline1 = $request->addressline1;
            $contact->addressline2 = $request->addressline2;
            $contact->neighborhood = $request->neighborhood;
            $contact->city = $request->city;
            $contact->state = $request->state;
            $contact->zipcode = $request->zipcode;
            $contact->bankcode = $request->bankcode;
            $contact->bank = $request->bank;
            $contact->bankbranch = $request->bankbranch;
            $contact->bankaccount = $request->bankaccount;
            $contact->bankaccountdigito = $request->bankaccountdigito;
            
            $contact->save();
            if(!$contact) return response()->json(['success'=>false,"message" => 'Problema ao salvar.']);
            
            return response()->json(['success'=>true,"data" => ["contatos" => $contact]]);
        }


        return response()->json(['success'=>false,"message" => 'Problema ao salvar.']);
    }
    
}
