<?php

namespace App\Http\Controllers;

use App\Client;
use App\Barcodepayment;
use App\Classes\ClientSPS\ClientSpsService;
use JWTAuth;

use App\Darfpayment;
use App\Darjpayment;
use App\Fgtspayment;
use App\Gpspayment;
use App\Garepayment;
use App\Transferlog;
use DB;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Facades\JWTAuth as FacadesJWTAuth;

class ApiPagamentoController extends Controller
{
    public function consultaCodbarras(Request $request)
    {
        $userInfo = JWTAuth::user();

        $spsInfo = getSPS();

        $curlParams = "{ \"Method\": \"GetInfosByBarcode\",
                        \"PartnerId\": ".$spsInfo->partnerid.",
                        \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                        \"Barcode\": \"".trim(somenteNumeros($request->input('barcode')))."\"}";

        $consulta = sendCurl($curlParams);

        if($consulta["Success"] == "false") {
            return response()->json(["success" => false,"message" => "Erro ao consultar boleto. ".$consulta['Message']]);
        }

        $boleto = json_decode($consulta['Infos']);

        if($boleto->ConcessionaireCode != null) {
            return response()->json(["success" => true,
                                    "data" => ["resposta" => [
                                        "digitableline" => $boleto->DigitableLine,
                                        "barcode" => $boleto->Barcode,
                                        "duedate" => detectDateFormatOutputDateBr($boleto->DueDate),
                                        "bankcode" => (!empty($boleto->BankCode)) ? $boleto->BankCode : '',
                                        "bankname" => (!empty($boleto->BankName)) ? $boleto->BankName : '',
                                        "value" => formatMoneyBr($boleto->Value),
                                        "concessionairename" => $boleto->ConcessionaireName,
                                        "concessionairecode" => $boleto->ConcessionaireCode
                                    ],
                                    "concessionaria" => 1,
                                    "cod_barras" => somenteNumeros($boleto->Barcode)
                                ]
                                ]);
        } else { // boletos em geral
            $client = getClientById($userInfo->client_id);

            $curlParams = "{ \"Method\": \"GetInfosCIPByBarcode\",
                        \"TaxNumber\": ".somenteNumeros($client->taxnumber).",
                        \"PartnerId\": ".$spsInfo->partnerid.",
                        \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                        \"Barcode\": \"".trim(somenteNumeros($boleto->Barcode))."\"}";

            $consulta = sendCurl($curlParams);

            if($consulta["Success"] == "false") {
                return response()->json(["success" => false,"message" => "Erro ao consultar detalhes do boleto. ".$consulta['Message']]);
            }

            $boleto = json_decode($consulta['Infos']);

            if(!isset($boleto->Drawer)) {
                return response()->json(["success" => false,"message" => "Erro ao consultar detalhes do boleto: ".$consulta['Message']]);
            }

            return response()->json(["success" => true,
                                    "data" => [
                                        "resposta" => [
                                            "drawer" => $boleto->Drawer,
                                            "taxnumberbeneficiary" => $boleto->TaxNumberBeneficiary,
                                            "taxnumberdrawee" => $boleto->TaxNumberDrawee,
                                            "paymentdate" => detectDateFormatOutputDateBr($boleto->PaymentDate),
                                            "datedueregistration" => detectDateFormatOutputDateBr($boleto->DateDueRegistration),
                                            "beneficiaryname" => $boleto->BeneficiaryName,
                                            "draweename" => $boleto->DraweeName,
                                            "discountvalue" => formatMoneyBr($boleto->DiscountValue),
                                            "interestvalue" => formatMoneyBr($boleto->InterestValue),
                                            "maxpaymentvalue" => formatMoneyBr($boleto->MaxPaymentValue),
                                            "minpaymentvalue" => formatMoneyBr($boleto->MinPaymentValue),
                                            "finevalue" => formatMoneyBr($boleto->FineValue),
                                            "nominalvalue" => formatMoneyBr($boleto->NominalValue),
                                            "updatedvalue" => formatMoneyBr($boleto->UpdatedValue),
                                            "totalrebatevalue" => formatMoneyBr($boleto->TotalRebateValue),
                                            "totaladdedvalue" => formatMoneyBr($boleto->TotalAddedValue),
                                            "settlementdate" => detectDateFormatOutputDateBr($boleto->SettlementDate),
                                            "duedate" => detectDateFormatOutputDateBr($boleto->DueDate),
                                            "nextsettlement" => $boleto->NextSettlement,
                                            "digitableline" => $boleto->DigitableLine,
                                            "value" => formatMoneyBr($boleto->Value),
                                            "maxvalue" => formatMoneyBr($boleto->MaxValue),
                                            "minvalue" => formatMoneyBr($boleto->MinValue),
                                            "paymentwasmade" => $boleto->PaymentWasMade
                                        ],
                                        "concessionaria" => 0,
                                        "cod_barras" => somenteNumeros($request->input('barcode'))
                                    ]]);

        }

        return response()->json(["success" => false,"message" => "Erro ao consultar boleto. "]);

    }





    /** *****************************************
     ********************************************
     *                  PAGaMENTOS
     ********************************************
     ********************************************
    */
    public function consultaPagamento(Request $request)
    {

        $results = $this->queryResults($request, new Barcodepayment());

        $listitens = [];

        foreach($results['object'] as $item) {
            $listitens[] = [
                    'id' => $item->id,
                    'duedate' => detectDateFormatOutputDateBr($item->duedate),
                    'principalvalue' => formatMoneyBr(zeroNull($item->principalvalue)),
                    'discountvalue' => formatMoneyBr(zeroNull($item->discountvalue)),
                    'extravalue' => formatMoneyBr(zeroNull($item->extravalue)),
                    'totalvalue' => formatMoneyBr(zeroNull($item->totalvalue)),
                    'paymentdate' => detectDateFormatOutputDateBr($item->paymentdate),
                    'status' => traduzStatusApi($item->status),
                    'identifier' => $item->identifier,
                    'documentnumber' => $item->documentnumber,
                    'paymentauthentication' => replaceNullValueWithEmptyString($item->paymentauthentication),
                    'receipturl' => replaceNullValueWithEmptyString($item->receipturl)
            ];
        }

        return response()->json(
            [
                "success" => true,
                "data" => [
                            "resposta" => $listitens,
                            "filtro" => $results['filtro'],
                            "itens" => $results['object']->count()
                        ],
            ]
        );
    }

    public function queryResults($request, $tipo)
    {
        $userInfo = JWTAuth::user();
        $client = Client::select('clients.*')->where('id', '=', $userInfo->client_id)->first();

        if ($request->input('datade') != ''  && $request->input('dataate') != '') {
            $datade  = date2us($request->input('datade'));
            $dataate = date2us($request->input('dataate'));
        } else {
            $datade  = date('Y-m-d', strtotime('-15 days'));
            $dataate = date('Y-m-d');
        }

        $q_sql = $tipo->where('user_id', '=', $userInfo->client_id)
                            ->whereDate('emission', '>=', $datade)
                            ->whereDate('emission', '<=', $dataate);

        if(isset($request) && $request->input('filtrostatus') != '') {
            $q_sql->where('status', '=', $request->input('filtrostatus'));
        }


        $results = $q_sql->orderBy('created_at', 'desc')->get();

        $filtrostatus  = (isset($request) && $request->input('filtrostatus') != '') ? $request->input('filtrostatus') : '';

        $filtro = array('datade' => dataUs2Br($datade),'dataate' => dataUs2Br($dataate), 'filtrostatus' => $filtrostatus);

        return ["object" => $results,"filtro" => $filtro];
    }


    /* ******************************************************
       ******************************************************

        SUBMITS

       ******************************************************
       ****************************************************** */

    public function enviaPagamento(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'taxnumber' => ['required', 'max:14', 'min:14'],
            'valor' => 'required',
            'limiteespecial' => 'required',
            'identificador' => 'required',
            'tipoconta' => 'required',
            'documento' => 'required',
            'nome' => 'required',
            'banco' => 'required',
            'agencia' => 'required',
            'conta' => 'required',
            'digito' => 'required',
        ], [
            'taxnumber.required' => 'O CNPJ é obrigatório.',
            'taxnumber.max' => 'O CNPJ deve ter 14 caracteres e somente números.',
            'taxnumber.min' => 'O CNPJ deve ter 14 caracteres e somente números.',
            'valor.required' => 'O campo Valor é obrigatório.',
            'limiteespecial.required' => 'O campo Limite Especial é obrigatório.',
            'identificador.required' => 'O campo Identificador é obrigatório.',
            'tipoconta.required' => 'O campo Tipo de Conta é obrigatório.',
            'documento.required' => 'O campo Documento é obrigatório.',
            'nome.required' => 'O campo Nome é obrigatório.',
            'banco.required' => 'O campo Banco é obrigatório.',
            'agencia.required' => 'O campo Agência é obrigatório.',
            'conta.required' => 'O campo Conta é obrigatório.',
            'digito.required' => 'O campo Dígito é obrigatório.',
        ]);

        if ($validation->fails()) {
            return response()->json([
                "success" => false,
                "message" => $validation->errors()
            ]);
        }

        if (!operationTimeLimit('pagamento')) {
            return response()->json([
                "success" => false,
                "message" => "Pagamentos após o horário limite devem ser agendados para o próximo dia útil."
            ], 423);
        }

        $userInfo = FacadesJWTAuth::user();

        try {
            $client = new ClientSpsService($request->input('taxnumber'));
        } catch (\Exception $e) {
            return response()->json([
                "success" => false,
                "message" => "CNPJ não encontrado."
            ]);
        }

        if ($client->clientId !== $userInfo->client_id) {
            return response()->json([
                'success' => false,
                'message' => 'Você não possui permissão para acessar este CNPJ.',
            ], 403);
        }

        // CONSULTA O SALDO DO CLIENTE
        // $saldoCliente = saldoCliente($client->taxnumber);
        // $saldoDisponivel = $client->availablelimit;

        
        // CONSULTA O SALDO DO CLIENTE
        $saldoReal = $client->saldoReal;
        $saldoACompensar = $client->saldoCompensar;

        
        // valor a ser transferido
        $valor = $request->input('valor');
        $logLimitUsed = false;

        // valor a ser transferido
        // $valor = covert2Float($request->input('valor'));
        // $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

                
        // $cli_ratevalue = consultaTaxaCliente($client->id, 'moneytransfer', covert2Float($valor));
        $taxaTransferencia = $client->calculaTaxaDaOperacao('TRANSFERENCIA_EXTERNA', $valor);

        /**
         * O valor que ele deseja transferir + a taxa da transferência é o suficiente em conta?
         */
        $naoPossuiSaldoReal = ($valor + $taxaTransferencia) > $saldoReal;

        if ($naoPossuiSaldoReal) {

            /*
            * É possível utilizar o limite (saldo a compensar) ?
            */
            if ($request->input('limiteespecial') != 'Sim') {
                return response()->json(["success" => false,"message" => "Não há saldo suficiente para realizar a operação."]);
            }

            /**
             * $saldoAAdiantar = valor a ser adiantado sem taxa
             *
             * Inicialmente, usei
             * $saldoAAdiantar = $client->calculaSaldoAAdiantarParaOperacao('TRANSFERENCIA_INTERNA', $valor);
             * porém o valor retornado estava com a taxa.
             */
            $taxaAdiantamento = $client->calculaTaxaAdiantamentoParaOperacao('TRANSFERENCIA_INTERNA', $valor);
            $valorAAdiantar = $saldoCompensar - ($saldoReal - $valor);

            // saldo a transferir para completar o pagamento
            // $valorATransferir = ($valor - $saldoCliente);

            // ao saldo a transferir deve ser adicionada a taxa
            // $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $valorATransferir);
            // $cashback = $client->calculaTaxaDaOperacao('TRANSFERENCIA_INTERNA', $valorATransferir);

            /**
             * O saldo a compensar é menor do que o valor a adiantar + a taxa de adiantamento?
             */
            $naoPossuiSaldo = $saldoACompensar < $valorAAdiantar + $taxaAdiantamento;
            if ($naoPossuiSaldo) {
                return response()->json([
                    "success" => false,
                    "message" => "Não há saldo suficiente para realizar a operação."
                ]);
            }

            $adiantamento = transfereSaldoDisponivelCliente(
                $client->taxnumber,
                $valorAAdiantar,
                'Adiantamento de saldo a compensar',
                0,
                $taxaAdiantamento
            );

            // $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, $valorATransferir,
            //    'Transferencia de saldo a compensar', $cashback, $taxaTransferencia);

            // if(!$transfereSaldoDisponivel) return response()->json(["success" => false,"message" => "Ocorreu um
            // erro ao realizar a operação. Por favor tente mais tarde."]);

            if (! $adiantamento) {
                return response()->json([
                    "success" => false,
                    "message" => "Ocorreu um erro ao realizar a operação. Por favor tente mais tarde."
                ]);
            }

            $logLimitUsed = true;
            $saldoCompensar = 1;
            $saldoCompensarValor = $valorAAdiantar;
            $internaltransferdocumentnumber = $adiantamento;
        }
        // /CONSULTA O SALDO DO CLIENTE

        $spsInfo = getSPS();

        $vencimento = (!empty($request->input('duedate'))) ? dataSlashReverse($request->input('duedate')) : date('Y/m/d');

        $extravalue = covert2Float($request->input('interestvalue')) + covert2Float($request->input('finevalue'));

        $newIdentifier = concatIdentifier($request->input('identifier'));



        $curlParams = "{\"Method\": \"GenerateBoletoOut\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"Name\": \"".$client->name."\",
                    \"TaxNumber\": ".$client->taxnumber.",
                    \"Barcode\": \"".$request->input('barcode')."\",
                    \"PrincipalValue\": ".covert2Float($request->input('principalvalue')).",
                    \"DiscountValue\": ".covert2Float($request->input('discountvalue')).",
                    \"ExtraValue\": ".$extravalue.",
                    \"PaymentDate\": \"".dataSlashReverse($request->input('paymentdate'))."\",
                    \"DueDate\": \"".$vencimento."\",
                    \"Identifier\": \"".$newIdentifier."\",
                    \"RateValueType\": 1,
                    \"RateValue\": \"".$taxaTransferencia."\"
                }";

        $pagamento = sendCurl($curlParams);

        if($pagamento["Success"] == "false") {
            $validacao = (isset($pagamento['Validation'])) ? serialize($pagamento['Validation']) : '';
            $mensagem = (isset($pagamento['Message'])) ? $pagamento['Message'] : '';
            saveTransferErrorLog('GenerateBoletoOut', $curlParams, $mensagem, $validacao);

            return response()->json(["success" => false,"message" => "Erro: ocorreu um problema ao processar a requisição. Por favor tente mais tarde."]);
        }

        $documentnumber = (isset($pagamento['DocumentNumber'])) ? $pagamento['DocumentNumber'] : '0';
        $sucesso = ($pagamento["Success"] == "false") ? 0 : 1;
        $entryid = (isset($pagamento["EntryId"])) ? $pagamento["EntryId"] : '';
        $validacao = (isset($pagamento['Validation'])) ? serialize($pagamento['Validation']) : '';
        $mensagem = (isset($pagamento['Message'])) ? $pagamento['Message'] : '';
        $url = (isset($pagamento['Url'])) ? $pagamento['Url'] : '';
        $alreadyexists = (isset($pagamento['AlreadyExists'])) ? $pagamento['AlreadyExists'] : '';

        $checkDocnumber = $this->checkExists($documentnumber);
        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Operação realizada com sucesso.';
            $this->saveBarcodeLog(somenteNumeros($client->taxnumber), $request, $curlParams, $documentnumber, $entryid, $alreadyexists, 0, $url, $saldoCompensar, $saldoCompensarValor);

            if($logLimitUsed) {
                logAvailableLimitUsed($userInfo->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'BOLETO', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue);
            } // atualiza detalhamento
        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }

        savePaymentLog(
            $client->taxnumber,
            str_replace('/', '-', $vencimento),
            date2us($request->input('paymentdate')),
            'GenerateBoletoOut',
            concatIdentifier($request->input('identifier')),
            $documentnumber,
            $request->input('digitableline'),
            $curlParams,
            $sucesso,
            $mensagem,
            $validacao,
            $entryid,
            $url,
            covert2Float($request->input('principalvalue')),
            covert2Float($request->input('discountvalue')),
            covert2Float($extravalue)
        );

        return response()->json(["success" => true,"message" => $viewMessage]);
    }


    public function checkExists($docnumber)
    {
        $check = Barcodepayment::where('documentnumber', '=', $docnumber)->first();
        return (!$check) ? false : true;
    }


    /* ******************************************************
       ******************************************************

        COMPROVANTES

       ******************************************************
       ****************************************************** */
    public function consultaComprovantes(Request $request)
    {
        $userInfo = JWTAuth::user();
        $client = getClientById($userInfo->client_id);

        if ($request->input('datade') != ''  && $request->input('dataate') != '') {
            $datade  = date2us($request->input('datade'));
            $dataate = date2us($request->input('dataate'));
        } else {
            $datade  = date('Y-m-d', strtotime('-7 days'));
            $dataate = date('Y-m-d');
        }

        $darf = Darfpayment::select('id', 'receipturl', 'documentnumber', 'totalvalue as value', 'paymentdate', DB::raw('"Darf" as type'))
                                                ->where('client_id', '=', $userInfo->client_id)
                                                ->where('status', '=', 'Paid')
                                                ->whereDate('paymentdate', '>=', $datade)
                                                ->whereDate('paymentdate', '<=', $dataate)
                                                ->get();

        $darj = Darjpayment::select('id', 'receipturl', 'documentnumber', 'totalvalue as value', 'paymentdate', DB::raw('"Darj" as type'))
                                                ->where('client_id', '=', $userInfo->client_id)
                                                ->where('status', '=', 'Paid')
                                                ->whereDate('paymentdate', '>=', $datade)
                                                ->whereDate('paymentdate', '<=', $dataate)
                                                ->get();

        $fgts = Fgtspayment::select('id', 'receipturl', 'documentnumber', 'principalvalue as value', 'paymentdate', DB::raw('"Fgts" as type'))
                                                ->where('client_id', '=', $userInfo->client_id)
                                                ->where('status', '=', 'Paid')
                                                ->whereDate('paymentdate', '>=', $datade)
                                                ->whereDate('paymentdate', '<=', $dataate)
                                                ->get();

        $gps = Gpspayment::select('id', 'receipturl', 'documentnumber', 'principalvalue as value', 'paymentdate', DB::raw('"Gps" as type'))
                                                ->where('client_id', '=', $userInfo->client_id)
                                                ->where('status', '=', 'Paid')
                                                ->whereDate('paymentdate', '>=', $datade)
                                                ->whereDate('paymentdate', '<=', $dataate)
                                                ->get();

        $gare = Garepayment::select('id', 'receipturl', 'documentnumber', 'totalvalue as value', 'paymentdate', DB::raw('"Gare" as type'))
                                                ->where('client_id', '=', $userInfo->client_id)
                                                ->where('status', '=', 'Paid')
                                                ->whereDate('paymentdate', '>=', $datade)
                                                ->whereDate('paymentdate', '<=', $dataate)
                                                ->get();

        $barcodepayment = Barcodepayment::select('id', 'receipturl', 'documentnumber', 'totalvalue as value', 'paymentdate', DB::raw('"Pagamento" as type'))
                                                ->where('client_id', '=', $userInfo->client_id)
                                                ->where('status', '=', 'Paid')
                                                ->whereDate('paymentdate', '>=', $datade)
                                                ->whereDate('paymentdate', '<=', $dataate)
                                                ->get();

        $transfer = Transferlog::select('id', 'receipturl', 'documentnumber', 'valor as value', 'paymentdate', DB::raw('"Transferência" as type'))
                                                ->where('client_id', '=', $userInfo->client_id)
                                                ->where('status', '=', 'Paid')
                                                ->whereDate('paymentdate', '>=', $datade)
                                                ->whereDate('paymentdate', '<=', $dataate)
                                                ->get();

        $lista = $darf->concat($darj)->concat($fgts)->concat($gps)->concat($gare)->concat($barcodepayment)->concat($transfer);

        $listaOrd = $lista->sortBy('paymentdate');

        $filtro = array('datade' => dataUs2Br($datade),'dataate' => dataUs2Br($dataate));

        $comprovantes = [];

        foreach($listaOrd as $item) {
            $comprovantes[] = [
                    'id' => $item->id,
                    'receipturl' => replaceNullValueWithEmptyString($item->receipturl),
                    'documentnumber' => $item->documentnumber,
                    'value' => formatMoneyBr($item->value),
                    'paymentdate' => detectDateFormatOutputDateBr($item->paymentdate),
                    'type' => $item->type
            ];
        }

        return response()->json(
            [
                "success" => true,
                "data" => [
                            "resposta" => $comprovantes,
                            "filtro" => $filtro,
                            "itens" => $lista->count()
                        ],
            ]
        );
    }

    /* ******************  LOGS  ****************** */
    public function saveBarcodeLog($taxnumber, $request, $curlParams, $documentnumber, $entryid, $alreadyexists, $ratevalue, $url, $saldoCompensar, $saldoCompensarValor)
    {

        $userInfo = JWTAuth::user();
        $client = Client::select('clients.*')->where('id', '=', $userInfo->client_id)->first();

        $vencimento = (!empty($request->input('duedate'))) ? dataSlashReverse($request->input('duedate')) : date('Y/m/d');

        $logerror = new Barcodepayment();
        $logerror->user_id = $userInfo->id;
        $logerror->client_id = $userInfo->client_id;
        $logerror->emission = date('Y-m-d H:i:s');

        $logerror->name = $request->input('name');
        $logerror->taxnumber = somenteNumeros($client->taxnumber);
        $logerror->beneficiarytaxnumber = somenteNumeros($request->input('beneficiarytaxnumber'));
        $logerror->beneficiaryname = $request->input('beneficiaryname');
        $logerror->guarantortaxnumber = somenteNumeros($request->input('guarantortaxnumber'));
        $logerror->guarantorname = $request->input('guarantorname');
        $logerror->payertaxnumber = somenteNumeros($request->input('payertaxnumber'));
        $logerror->payername = $request->input('payername');
        $logerror->mailtosend = $request->input('mailtosend');
        $logerror->phonetosend = $request->input('phonetosend');
        $logerror->barcode = $request->input('barcode');
        $logerror->principalvalue = covert2Float($request->input('principalvalue'));
        $logerror->discountvalue = zeroNull(covert2Float($request->input('discountvalue')));
        $logerror->extravalue = zeroNull(covert2Float($request->input('extravalue')));
        $logerror->paymentdate = date2us($request->input('paymentdate'));
        $logerror->duedate = $vencimento;
        $logerror->feepayertaxnumber = $request->input('feepayertaxnumber');
        $logerror->feepayerfullname = $request->input('feepayerfullname');
        $logerror->feepayermail = $request->input('feepayermail');
        $logerror->feepayerphone = $request->input('feepayerphone');
        $logerror->feepayerbank = $request->input('feepayerbank');
        $logerror->feepayerbankbranch = $request->input('feepayerbankbranch');
        $logerror->feepayerbankaccount = $request->input('feepayerbankaccount');
        $logerror->feepayerbankaccountdigit = $request->input('feepayerbankaccountdigit');
        $logerror->description = $request->input('description');
        $logerror->identifier = concatIdentifier($request->input('identifier'));
        $logerror->ratevaluetype = $request->input('ratevaluetype');
        $logerror->ratevalue = $request->input('ratevalue');
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
        $logerror->receipturl = $url;

        $logerror->status = 0;
        $logerror->documentnumber = $documentnumber;
        $logerror->alreadyexists = $alreadyexists;
        $logerror->datasent = $curlParams;


        $logerror->save();

        return true;
    }

}
