<?php namespace App\Http\Controllers;

use App\Client;
use App\Fgtspayment;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;

class ApiFgtsController extends Controller
{
    /** *****************************************
     ********************************************
     *                  FGTS
     ********************************************
     ********************************************
    */

    public function consultaFgts(Request $request)
    {
        
        $results = $this->queryResults($request,new Fgtspayment);

        $listitens = [];

        foreach($results['object'] as $item) {
            $listitens[] = [
                    'id' => $item->id,
                    'duedate' => detectDateFormatOutputDateBr($item->duedate),
                    'principalvalue' => formatMoneyBr($item->principalvalue),
                    'totalvalue' => formatMoneyBr($item->totalvalue),
                    'paymentdate' => detectDateFormatOutputDateBr($item->paymentdate),
                    'status' => traduzStatusApi($item->status),
                    'identifier' => $item->identifier,
                    'documentnumber' => $item->documentnumber,
                    'contributortaxnumber' => formataCNPJ($item->contributortaxnumber),
                    'paymentauthentication' => replaceNullValueWithEmptyString($item->paymentauthentication),
                    'receipturl' => replaceNullValueWithEmptyString($item->receipturl)
            ];
        }

        return response()->json(
            [
                "success" => true,
                "data" =>[
                            "resposta" => $listitens,
                            "filtro" => $results['filtro'],
                            "itens" => $results['object']->count()
                        ],
            ]
        );
    }

    public function queryResults($request, $tipo) {
        $userInfo = JWTAuth::user();
        $client = Client::select('clients.*')->where('id','=',$userInfo->client_id)->first();
        
        if ($request->input('datade') != ''  && $request->input('dataate') != '') {
            $datade  = date2us($request->input('datade'));
            $dataate = date2us($request->input('dataate')); 
        } else {
            $datade  = date('Y-m-d', strtotime('-15 days'));
            $dataate = date('Y-m-d');   
        }

        $q_sql = $tipo->where('client_id','=',$userInfo->client_id)
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

        if(isset($request) && $request->input('filtrostatus') != '')
            $q_sql->where('status','=',$request->input('filtrostatus'));


        $results = $q_sql->orderBy('created_at','desc')->get();

        $filtrostatus  = (isset($request) && $request->input('filtrostatus') != '')?$request->input('filtrostatus'):'';

        $filtro = array('datade'=>dataUs2Br($datade),'dataate'=>dataUs2Br($dataate), 'filtrostatus'=>$filtrostatus);

        return ["object"=>$results,"filtro"=>$filtro];
    }

    /* ******************************************************
       ******************************************************
        
        SUBMITS

       ******************************************************
       ****************************************************** */

    public function enviaFgts(Request $request) {
        $userInfo = JWTAuth::user();
        $client = getClientById($userInfo->client_id);

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($client->taxnumber);
        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        $valor = covert2Float($request->input('principalvalue'));
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        // verifica se o disponível é >= valor a ser transferido
        if($valor > $saldoCliente) {
            // se não for, verifica se permite usar saldo a compensar
            if( $request->input('limiteespecial') == 'Sim' ) {

                // saldo a transferir para completar o pagamento
                $saldoATransferir = ($valor - $saldoCliente);

                // ao saldo a transferir deve ser adicionada a taxa
                $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $saldoATransferir);

                // verifica se o cliente possui saldo a compensar suficiente
                if( ($saldoCliente + $saldoDisponivel) < ($valor + $cashbackvalue) ) {
                    return response()->json(["success" => false,"message" => "Não há saldo suficiente para realizar a operação."]);
                } else {
                    // realiza a transferencia do valor adicional para o cliente
                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, ( $saldoATransferir + $cashbackvalue), 'Transferencia de saldo a compensar', $cashbackvalue);

                    if(!$transfereSaldoDisponivel) return response()->json(["success" => false,"message" => "Ocorreu um erro ao realizar a operação. Por favor tente mais tarde."]);

                    // $logLimitUsed = logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARF', '0', false); // salva detalhamento
                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoATransferir;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            } else {
                return response()->json(["success" => false,"message" => "Não há saldo suficiente para realizar a operação."]);
            }
        }
        // /CONSULTA O SALDO DO CLIENTE

        $newIdentifier = concatIdentifier($request->input('identifier'));

        $spsInfo = getSPS();

        $curlParams = "{ \"Method\": \"GeneratePaymentFGTS\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".somenteNumeros($client->taxnumber)."\",
                    \"ContributorTaxNumber\": \"".somenteNumeros($request->input('contributortaxnumber'))."\",
                    \"PrincipalValue\": ".covert2Float($request->input('principalvalue')).",
                    \"CodeRevenue\": \"".$request->input('coderevenue')."\",
                    \"Barcode\": \"".somenteNumeros($request->input('barcode'))."\",
                    \"FgtsIdentifier\": \"".$request->input('fgtsidentifier')."\",
                    \"SocialConnectivityCode\": \"".$request->input('socialconnectivitycode')."\",
                    \"SocialConnectivityDigit\": \"".$request->input('socialconnectivitydigit')."\",
                    \"PaymentDate\": \"".dataSlashReverse($request->input('paymentdate'))."\",
                    \"Tags\": [],
                    \"RateValueType\": \"1\",
                    \"Description\": \"".$request->input('description')."\",
                    \"Identifier\": \"".$newIdentifier."\"
                }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('GeneratePaymentFGTS', $curlParams, $mensagem, $validacao);

            return response()->json(["success" => false,"message" => "Erro: ocorreu um problema ao processar a requisição. Por favor tente mais tarde."]);
        }

        $documentnumber = (isset($enviar['DocumentNumber']))?$enviar['DocumentNumber']:'0';
        $alreadyexists = (isset($enviar['AlreadyExists']))?1:0;

        $checkDocnumber = $this->checkExists($documentnumber);

        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Documento enviado.';
            $this->saveFgtsLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$alreadyexists, 0, $newIdentifier,$saldoCompensar,$saldoCompensarValor);

            if($logLimitUsed) logAvailableLimitUsed($userInfo->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'FGTS', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento
        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }

        return response()->json(["success" => true,"message" => $viewMessage]);
    }

    

    
    public function checkExists($docnumber) {
        $check = Fgtspayment::where('documentnumber','=',$docnumber)->first();
        return (!$check)?false:true;
    }


    /* ******************  LOGS  ****************** */

    public function saveFgtsLog($taxnumber, $request, $curlParams,$documentnumber,$alreadyexists,$ratevalue, $newIdentifier, $saldoCompensar,$saldoCompensarValor) {

        $userInfo = JWTAuth::user();

        $logerror = new Fgtspayment();
        $logerror->user_id = $userInfo->id;
        $logerror->client_id = $userInfo->client_id;
        $logerror->taxnumber = $taxnumber;
        $logerror->emission = date('Y-m-d H:i:s');
        $logerror->contributortaxnumber = somenteNumeros($request->input('contributortaxnumber'));
        $logerror->principalvalue = covert2Float($request->input('principalvalue'));
        $logerror->coderevenue = $request->input('coderevenue');
        $logerror->barcode = $request->input('barcode');
        $logerror->fgtsidentifier = $request->input('fgtsidentifier');
        $logerror->socialconnectivitycode = $request->input('socialconnectivitycode');
        $logerror->socialconnectivitydigit = $request->input('socialconnectivitydigit');
        $logerror->paymentdate = date2us($request->input('paymentdate'));
        $logerror->description = $request->input('description');
        $logerror->identifier = $newIdentifier;
        $logerror->ratevalue = $ratevalue;
        $logerror->status = 0;
        $logerror->documentnumber = $documentnumber;
        $logerror->alreadyexists = $alreadyexists;
        $logerror->datasent = $curlParams;
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
        $logerror->save();

        return true;
    }
}
