<?php namespace App\Http\Controllers;

use App\Address;

use Illuminate\Http\Request;

class AddressController extends Controller
{

	public function index()
	{

		$addresses = Address::all();
		$status=(!$addresses)?false:true;
		return response()->json(['status'=>$status,'result' => $addresses]);
	}


	public function store(Request $request)
	{

		$addresses = new Address($request->all());
		$addresses->save();
		if(!$addresses) { return response()->json(['status'=>false,'result' => 'Houve um problema ao salvar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $addresses]);
	}


	public function show(Request $request, $id)
	{

		$addresses = Address::findOrFail($id);
		if(!$addresses) { return response()->json(['status'=>false,'result' => 'Oops! Nada foi encontrado.']); }
		return response()->json(['status'=>true,'result' => $addresses]);
	}


	public function update(Request $request, $id)
	{

		$addresses = Address::findOrFail($id);
		$addresses->update($request->all());
		if(!$addresses) { return response()->json(['status'=>false,'result' => 'Houve um problema ao atualizar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $addresses]);
	}


	public function destroy($id)
	{

		$addresses = Address::findOrFail($id);
		$addresses->delete();
		if(!$addresses) { return response()->json(['status'=>false,'result' => 'Houve um problema ao excluir. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => 'O item foi removido com sucesso.']);
	}


}
