<?php namespace App\Http\Controllers;

use App\Actionlog;

use Illuminate\Http\Request;

class ActionlogController extends Controller
{

	public function index()
	{

		$actionlogs = Actionlog::all();
		$status=(!$actionlogs)?false:true;
		return response()->json(['status'=>$status,'result' => $actionlogs]);
	}


	public function store(Request $request)
	{

		$actionlogs = new Actionlog($request->all());
		$actionlogs->save();
		if(!$actionlogs) { return response()->json(['status'=>false,'result' => 'Houve um problema ao salvar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $actionlogs]);
	}


	public function show(Request $request, $id)
	{

		$actionlogs = Actionlog::findOrFail($id);
		if(!$actionlogs) { return response()->json(['status'=>false,'result' => 'Oops! Nada foi encontrado.']); }
		return response()->json(['status'=>true,'result' => $actionlogs]);
	}


	public function update(Request $request, $id)
	{

		$actionlogs = Actionlog::findOrFail($id);
		$actionlogs->update($request->all());
		if(!$actionlogs) { return response()->json(['status'=>false,'result' => 'Houve um problema ao atualizar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $actionlogs]);
	}


	public function destroy($id)
	{

		$actionlogs = Actionlog::findOrFail($id);
		$actionlogs->delete();
		if(!$actionlogs) { return response()->json(['status'=>false,'result' => 'Houve um problema ao excluir. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => 'O item foi removido com sucesso.']);
	}


}
