<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Client;
use App\Multisafe;
use Illuminate\Support\Facades\DB;

class LancarMensalidades extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:lancarmensalidades';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Lança as mensalidades';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $mesAtual = date('m');
        $hoje = date('d');
        $dataCompletaHoje = date('Y-m-d');

        $clientes = Client::select('id', DB::raw("0 as client_id"), 'taxnumber', 'availablelimit', 'monthlyfee')
            ->where('active', '1')
            ->where('monthlyfee', '>', 0)
            ->where('monthlyfeedueday', $hoje);

        $todosClientesAtivos = Multisafe::select('id', 'client_id', 'taxnumber', 'availablelimit', 'monthlyfee')
            ->where('active', '1')
            ->where('monthlyfee', '>', 0)
            ->where('monthlyfeedueday', $hoje)
            ->union($clientes)
            ->get();

        foreach ($todosClientesAtivos as $cliente) {

            $existeMensalidade = verificarSeExisteMensalidade($cliente->taxnumber, $mesAtual);

            if(!$existeMensalidade) {
                logAvailableLimitUsed(
                    1,
                    $cliente->id,
                    $cliente->taxnumber,
                    $cliente->availablelimit,
                    $cliente->monthlyfee,
                    'MENSALIDADE',
                    '0',
                    false,
                    '0',
                    0.00,
                    $dataCompletaHoje . ' 23:59:59',
                );

            }
        }
    }
}
