<?php

namespace App\Console\Commands;

use App\Mail\EnviaMailAnexo;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class GeraRelatorioDxAutomatico extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:gerarrelatoriodxautomatico';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->limparLog();
        $this->gerarrelatorio();
        $this->sendEmail();
    }

    public function gerarrelatorio()
    {

        $query = DB::raw("
    SELECT
    a.id,
    a.fromtaxnumber AS CNPJ,
    COALESCE(
        (SELECT c.name FROM clients AS c WHERE c.taxnumber = a.fromtaxnumber LIMIT 1),
        (SELECT m.nickname FROM multisafes AS m WHERE m.taxnumber = a.fromtaxnumber LIMIT 1)
    ) AS nome_cliente,
    a.operationtype AS operacao,
    a.scheduleddatetime AS data_agendamento_transferencia,
    a.operationstatus AS status_agendamento_transferencia,
    a.operationresponse AS mensagem,
    a.updated_at AS data_ultima_atualizacao
FROM autotransferschedule AS a
WHERE
    DATE(a.updated_at) = CURDATE()
AND
    a.operationstatus like 'ERRO%'
ORDER BY a.updated_at DESC;");

        $result = DB::select($query);

        if (empty($result)) {
            return;
        }


        $filePath = storage_path("logs/agendamentos/agendardxautomatico.csv");
        $file = fopen($filePath, 'w');
        fprintf($file, chr(0xEF) . chr(0xBB) . chr(0xBF));
        //header do csv
        $header = ["ID, CNPJ, Nome Cliente, Operacao, Data Agendamento Transferencia, Mensagem, Status Agendamento Transferencia, Data Ataulizacao"];
        //body do csv
        $body =  array_map(function ($cliente) {
            return implode(',', (array) $cliente);
        }, (array) $result);

        $csv = array_merge($header, $body);
        file_put_contents($filePath, implode("\n", $csv) . "\n", FILE_APPEND);
    }

    public function limparLog()
    {

        $diretorio = storage_path("logs/agendamentos/");
        $arquivos = glob($diretorio . '*');

        foreach ($arquivos as $arquivo) {
            if (is_file($arquivo)) {
                unlink($arquivo);
            }
        }
    }

    public function sendEmail()
    {

        $filePath = storage_path('logs/agendamentos/agendardxautomatico.csv');

        if (!file_exists($filePath)) {
            return;
        }

        $destinatario = 'sistemas@smartsafebrasil.com.br';
        $from = 'naoresponda@ssgbank.com.br';
        $subject = 'Relatório de agendamentos de transferências automáticas';
        $message = 'Relatório de agendamentos de transferências automáticas em anexo.';

        Mail::send(new EnviaMailAnexo($from, $destinatario, $subject, $message, $filePath));
    }
}
