<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class DatabaseBackUp extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'database:backup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Backup dp banco de dados';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $now = date('Ymd')."_0800";

        // $filename = "backup-ssg-" . $now . ".zip";
        $filename = "backup-" . $now . ".gz";

        $dbPassword = config("database.connections.mysql.password");

        $dumpPassword = config("app.backup.dumpPassword");

        // $command = "mysqldump --user=spsbank --password='". $dbPassword ."' --ignore-table=spsbank.logscurl --host=localhost spsbank | gzip | zip -P " . $dumpPassword . " /data/backups-ssg/" . $filename . " -";

        $command = "mysqldump --user=spsbank --password='". $dbPassword ."' --ignore-table=spsbank.logscurl --host=localhost spsbank | gzip > " . storage_path() . "/app/backup/" . $filename;

        $returnVar = NULL;
        $output  = NULL;

        try {
            exec($command, $output, $returnVar);
        } catch (\Exception $error) {
            Log::error('Erro ao criar dump ' . $now . ': ' . json_encode($error->getMessage()));
        }
    }
}
