<?php

namespace App\Console\Commands;

use App\Classes\ClientSPS\ClientSpsService;
use Illuminate\Console\Command;
use App\Client;
use App\Usedavailablelimit;

class CobrarTaxas extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:cobrartaxas';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Cobra os juros sobre a utilizacao do limite disponivel de acordo com os dias utilizados';

    protected $amanha;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->amanha = date('Y-m-d', strtotime('+1 day'));

        $limitesUtilizadosNaoPagos = Usedavailablelimit::where('paid', '=', 0)
            // ->whereDate('duedate', '>=', $amanha . ' 00:00:01')
            // ->whereDate('duedate', '<=', $amanha . ' 23:59:59')
            ->whereBetween('duedate', [$this->amanha.' 00:00:01', $this->amanha.' 23:59:59'])
            ->where('interestvalue', '>', '0')
            ->orderBy('emission', 'asc')
            ->get();

        foreach($limitesUtilizadosNaoPagos as $objLimite) {
            $idTaxaPermanencia = logAvailableLimitUsed(
                1,
                $objLimite->client_id,
                $objLimite->taxnumber,
                0,
                $objLimite->interestvalue,
                'TAXA_PERMANENCIA',
                'SSG_' . $objLimite->id,
                false,
                0,
                0,
                (date("Y-m-d") . ' 23:59:59')
            );

            $objLimite->interestvalue = 0;
            $objLimite->update();

            $objTaxaPermancia = Usedavailablelimit::find($idTaxaPermanencia);

            $this->cobrarTaxa($objTaxaPermancia);
        }
    }

    public function cobrarTaxa(Usedavailablelimit $objLimite)
    {
        $array = prepararSaldoParaPagamentoLimitesUtilizados($objLimite, true, true);

        $arrayPagamentoFinalizado = finalizarPagamentoLimitesUtilizados($objLimite, $array['valorATransferirParaSPS'], $array['valorProvisionado']);

        if ( $arrayPagamentoFinalizado['pagou'] == false ) {
            $clientSpsService = new ClientSpsService($objLimite->taxnumber);

            $valorOperacao = $objLimite->ratevalue + $objLimite->requestedvalue + $objLimite->interestvalue - $objLimite->paymentvalue;

            if ($valorOperacao <= 0.009) {
                $objLimite->paid = 1;
            } else {
                $objLimite->duedate = $this->amanha . ' 09:00:00';
                $objLimite->ratevalue = $clientSpsService->calculaTaxaDaOperacao("ADIANTAMENTO", $valorOperacao);
            }

            $objLimite->update();
        }
    }
}
