<?php

namespace App\Console\Commands;

use App\Client;
use App\Multisafe;
use App\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class ChangeFromClientToMultisafe extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'change-client-to-multisafe {--client=} {--target=} {--future-client=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Transforma um cliente mãe (ativo) em filho';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // target é o cliente-mãe que desejo transformar em filho
        $target = $this->option('target');
        $targetData = Client::where('taxnumber', '=', $target)
            ->where('active', '=', '1')
            ->first();

        // client é o cliente-mãe que será mãe do target
        $client = $this->option('client');
        $clientData = Client::where('taxnumber', '=', $client)
            ->where('active', '=', '1')
            ->first();

        // futureClient é o cliente-filho do target que será transformado em mãe
        $futureClient = $this->option('future-client');
        $futureClientData = Multisafe::where('taxnumber', '=', $futureClient)
            ->where('maintaxnumber', '=', $target)
            ->where('active', '=', '1')
            ->first();

        $children = Multisafe::where('maintaxnumber', '=', $target)
            ->where('taxnumber', '<>', $futureClient)
            ->get();

        $users = User::where('client_id', '=', $targetData->id)
            ->get();

        DB::beginTransaction();

        try {
            $newChild = Multisafe::create([
                'client_id' => $clientData->id,
                'maintaxnumber' => $client,
                'taxnumber' => $targetData->taxnumber,
                'active' => '1',
                'businessunitid' => $targetData->businessunitid,
                'mail' => $targetData->mail,
                'phone' => $targetData->phone,
                'nickname' => $targetData->nickname,
                'availablelimit' => $targetData->availablelimit,
                'monthlyfee' => $targetData->monthlyfee,
                'monthlyfeeautodebit' => $targetData->monthlyfeeautodebit,
                // 'montlyfeedueday' => $targetData->monthlyfeedueday,
                'd0automatic' => $targetData->d0automatic,
                'd0time' => $targetData->d0time,
            ]);

            $newMother = Client::create([
                'taxnumber' => $futureClient,
                'businessunitid' => $futureClientData->businessunitid,
                'mail' => $futureClientData->mail,
                'phone' => $futureClientData->phone,
                'nickname' => $futureClientData->nickname,
                'name' => $futureClientData->nickname,
                'banknumber' => $targetData->banknumber,
                'bankbranch' => $targetData->bankbranch,
                'bankaccount' => $targetData->bankaccount,
                'allowlimit' => $targetData->allowlimit,
                'availablelimit' => $futureClientData->availablelimit,
                'customrates' => $targetData->customrates,
                'payments' => $targetData->payments,
                'paymentspercentage' => $targetData->paymentspercentage,
                'transfers' => $targetData->transfers,
                'transferspercentage' => $targetData->transferspercentage,
                'billets' => $targetData->billets,
                'billetspercentage' => $targetData->billetspercentage,
                'p2p' => $targetData->p2p,
                'p2ppercentage' => $targetData->p2ppercentage,
                'balanceusage' => $targetData->balanceusage,
                'balanceusagepercentage' => $targetData->balanceusagepercentage,
                'monthlyfee' => $futureClientData->monthlyfee,
                'monthlyfeeautodebit' => $futureClientData->monthlyfeeautodebit,
                'monthlyfeedueday' => $futureClientData->monthlyfeedueday,
                'd0automatic' => $futureClientData->d0automatic,
                'd0time' => $futureClientData->d0time,
            ]);

            foreach ($children as $child) {
                $child->update([
                    'client_id' => $newMother->id,
                    'maintaxnumber' => $newMother->taxnumber,
                ]);
            }

            foreach ($users as $user) {
                $user->update([
                    'client_id' => $newMother->id,
                ]);
            }

            $targetData->delete();
            $futureClientData->delete();

            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();

            $this->error($th->getMessage());
        }
    }
}
