<?php

namespace App\Console\Commands;

use App\Client;
use App\Multisafe;
use App\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class ChangeClientOfMultisafe extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'change-client-of-multisafe
        {--target= : CNPJ do cliente-filho alvo da mudança}
        {--new-client= : CNPJ do cliente-mãe que será atribuido ao cliente alvo}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Altera o cliente mãe de um cliente filho';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        DB::beginTransaction();

        try {

            $target = $this->option('target');

            if ($target === null) {
                throw new \Exception("A opção \"--target\" é obrigatória. Utilize `php artisan change-client-of-multisafe --help` para detalhes.");
            }

            // target é o cliente-filho que desejo ter a mãe alterada
            $targetData = Multisafe::query()
                ->where('taxnumber', '=', $target)
                ->where('active', '=', '1')
                ->first();

            if (! $targetData) {
                throw new \Exception("Cliente-filho não encontrado");
            }

            // newClient é o cliente-mãe que receberá o target como novo filho
            $newClient = $this->option('new-client');

            if ($newClient === null) {
                throw new \Exception("A opção \"--new-client\" é obrigatória. Utilize `php artisan change-client-of-multisafe --help` para detalhes.");
            }

            $newClientData = Client::query()
                ->where('taxnumber', '=', $newClient)
                ->where('active', '=', '1')
                ->first();

            if (! $newClientData) {
                throw new \Exception("Cliente-mãe não encontrado");
            }

            $targetData->client_id = $newClientData->id;
            $targetData->maintaxnumber = $newClientData->taxnumber;

            $targetData->save();

            $targetData->refresh();

            $this->info("Cliente alterado.");
            dump($targetData->only(['nickname', 'taxnumber', 'client_id', 'maintaxnumber']));

            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();

            $this->warn("ERRO: " . $th->getMessage());

            return self::FAILURE;
        }
    }
}
