<?php

namespace App\Console\Commands;

use App\Classes\ClientSPS\ClientSpsService;
use Illuminate\Console\Command;
use App\Client;
use App\Multisafe;
use App\Usedavailablelimit;

class CalcularTaxas extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:calculartaxas';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Calcula os juros sobre a utilizacao do limite disponivel de acordo com os dias utilizados';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $diaSeguinte = date('Y-m-d', strtotime("+1 day")) . ' 09:00:00';

        $clientesComLimitesUtilizadosNaoPagos = Usedavailablelimit::selectRaw("DISTINCT taxnumber")
            ->where('paid', '=', 0)
            ->whereDate('duedate', '<=', date('Y-m-d') . ' 23:59:59')
            ->get();

        foreach($clientesComLimitesUtilizadosNaoPagos as $clienteDevedor) {

            $limitesUtilizadosNaoPagos = Usedavailablelimit::where('paid', '=', 0)
                ->whereDate('duedate', '<=', date('Y-m-d') . ' 23:59:59')
                ->where('taxnumber', '=', $clienteDevedor->taxnumber)
                ->orderBy('emission', 'asc')
                ->get();

            $objCliente = new ClientSpsService($clienteDevedor->taxnumber);

            foreach($limitesUtilizadosNaoPagos as $objLimite) {
                $this->calcularTaxa($objLimite, $objCliente, $diaSeguinte);
            }
        }
    }

    public function calcularTaxa(Usedavailablelimit $objLimite, object $objCliente, $diaSeguinte)
    {
        $valorAPagar = $objLimite->requestedvalue + $objLimite->ratevalue + $objLimite->interestvalue - $objLimite->paymentvalue;
        if ($valorAPagar <= 0) {
            $objLimite->duedate = $diaSeguinte;
            $objLimite->update();
            return false;
        }

        $dias = daysBetweenDates($diaSeguinte, $objLimite->duedate);

        // verifica o tipo de taxa negociada
        if ($objCliente->__get('balanceusagepercentage')) {

            // se percentual, aplica sobre o valor adiantado e número de dias
            $valorCobrado = (($objCliente->__get('balanceusage') * $valorAPagar) / 100 ) * $dias;

        } else {
            // se valor fixo, aplica sobre o número de dias
            $valorCobrado = ($objLimite->transactiontype == 'PERMANENCIA') ? 0 : $objCliente->__get('balanceusage') * $dias;
        }

        $objLimite->duedate = $diaSeguinte;
        $objLimite->interestvalue += $valorCobrado;
        $objLimite->update();

        return $objLimite->id;
    }
}
