<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Client;
use App\Usedavailablelimit;

class AvailablelimitInterestCalculator extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:availablelimitinterestcalculator';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Calcula os juros sobre a utilizacao do limite disponivel de acordo com os dias utilizados';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $limitesUtilizados = Usedavailablelimit::where('paid','=',0)->get();

        $hoje = now();

        foreach($limitesUtilizados as $lim) {

            if ($lim->paymentdate) {
                $dataReferencia = $lim->paymentdate;
            } else {
                $dataReferencia = $lim->emission;
            }

            $dias = daysBetweenDates($hoje, $dataReferencia);

            if($dias == 0) continue;

            //$atualizaJuros = $this->atualizaJuros($lim->id, $lim->client_id, $lim->taxnumber, $lim->requestedvalue, $dias);
            $atualizaTaxas = $this->atualizaTaxas($lim->id, $lim->client_id, $lim->taxnumber, $lim->requestedvalue, $lim->ratevalue, $lim->paymentvalue, $dias);

        }
        return 0;
    }

    // ZANE
    // baseada em atualizaJuros_ZaneRobson
    /*
    principal = 1000 <= juros compostos
    d1 = 1010
    d2 = 1020,10
    d3 = 1030,301
    d4 = 1040,60401

    principal = 1000 <= taxas no SPS
    d0 = 1000 + 10 = requested + rate = 1010
    d1 = (1000 + 10) 
       + (10 + 0,10)
    d2 = (1000 + 10) + (10 + 0,10) 
       + (10 + 0,10) + (0,10 + 0,001) = 1030,301
    d3 = (1000 + 10) + (10 + 0,10)    + (10 + 0,10)    + (0,10 + 0,001) 
       + (10 + 0,10) + (0,10 + 0,001) + (0,10 + 0,001) + (0,001 + 0,00001) = 1040,60401
    */
    public function atualizaTaxas($usedlimit_id,$client_id,$taxnumber,$requestedvalue,$ratevalue,$paymentvalue,$dias) {
        // OLD (Helder)
        //$spsInfo = getSPS();
        //$juros = (($spsInfo->clientbalanceusagedailycharge * $requestedvalue)/100 ) * $dias;

        $client = Client::where('id','=',$client_id)->first();
        $valorDevido = $requestedvalue + $ratevalue - $paymentvalue;
        if ($valorDevido < 0) { $valorDevido = 0; } // não será cobrada taxa diária sobre o ratevalue

        // verifica o tipo de taxa negociada
        if ($client->balanceusagepercentage) {
            // se percentual, aplica sobre o valor adiantado e número de dias
            $taxa = (($client->balanceusage * $valorDevido)/100 ) * $dias;
        } else {
            // se valor fixo, aplica sobre o número de dias
            // TODO -> como fazer com as taxas diárias? não pode cobrar o valor cheio pra cada dia de taxa adicionada
            $taxa = $client->balanceusage * $dias;
        }

        // atualizar o valor da taxa referente ao adiantamento
        $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
        $utilizado->interestvalue = $taxa;
        $utilizado->daysused = $dias;
        $utilizado->update();
        return $utilizado;
    }

    // ##### DEPRECATED out/21 #####
    // ZANE + ROBSON
    /*
    principal = 1000 <= juros compostos
    d1 = 1010
    d2 = 1020,10
    d3 = 1030,301
    d4 = 1040,60401

    principal = 1000 <= taxas no SPS
    d0 = 1000 + 10 = requested + rate = 1010
    d1 = (1000 + 10) 
       + (10 + 0,10)
    d2 = (1000 + 10) + (10 + 0,10) 
       + (10 + 0,10) + (0,10 + 0,001) = 1030,301
    d3 = (1000 + 10) + (10 + 0,10)    + (10 + 0,10)    + (0,10 + 0,001) 
       + (10 + 0,10) + (0,10 + 0,001) + (0,10 + 0,001) + (0,001 + 0,00001) = 1040,60401
    */
    public function atualizaJuros_ZaneRobson($usedlimit_id,$client_id,$taxnumber,$requestedvalue,$dias) {
        // OLD (Helder)
        //$spsInfo = getSPS();
        //$juros = (($spsInfo->clientbalanceusagedailycharge * $requestedvalue)/100 ) * $dias;

        $client = Client::where('id','=',$client_id)->first();

        // verifica o tipo de taxa negociada
        if ($client->balanceusagepercentage) {
            // se percentual, aplica sobre o valor adiantado e número de dias
            $juros = (($client->balanceusage * $requestedvalue)/100 ) * $dias;
        } else {
            // se valor fixo, aplica sobre o número de dias
            $juros = $client->balanceusage * $dias;
        }

        // atualizar o valor da taxa referente ao adiantamento
        $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
        $utilizado->interestvalue = $juros;
        $utilizado->daysused = $dias;
        $utilizado->update();
        return $utilizado;
    }
    /*
    public function atualizaJuros($usedlimit_id,$client_id,$taxnumber,$requestedvalue,$dias) {
        $spsInfo = getSPS();
        
        $juros = (($spsInfo->clientbalanceusagedailycharge * $requestedvalue)/100 ) * $dias;

        $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
        $utilizado->interestvalue = $juros;
        $utilizado->daysused = $dias;
        $utilizado->update();
        return $utilizado;
    }
    */

}
