<?php

namespace App\Classes;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
// models
use App\LogsCurl;
use App\Applicationlog;
use phpDocumentor\Reflection\PseudoTypes\False_;
use App\Classes\FluentdService;

class Log
{
    // Route::getCurrentRoute()->getActionName();
	public static function saveLogAplicacao($logLevel, $feature, $actionName, $mensagem, $success, $datajson, $id = 0)
	{
        //Log::testeLogAplicacao($logLevel, $feature, $actionName, $success, $mensagem, $datajson, $id = 0);

        // se não for para logar, retorna como id do log o numero 0
        if (!Log::deveLogarAplicacao($logLevel, $feature, $actionName)) {
            return 0;
        }

		// cria uma nova entrada de log, caso contrário, atualiza a existente
		if (0 == $id) {
			$log = new Applicationlog();
			$log->user_id = Auth::user()->id;
	    	$log->role_id = Auth::user()->role_id;
	    	$log->client_id = Auth::user()->client_id;
	    	$log->taxnumber = (is_null(Session::get('cnpj'))) ? 0 : (Session::get('cnpj'));
	    	$log->sessionid = Session::getId();
	    	$log->sessionjson = json_encode(Session::all());
            $log->loglevel = $logLevel;
            $log->action = $actionName;
		} else {
			$log = Applicationlog::where('id', '=', $id)->first();
		}
        $log->message = $mensagem;
        $log->success = $success;
        $log->datajson = $datajson;
		$log->save();


		return $log->id;
    }

    public static function deveLogarAplicacao($logLevel, $feature, $actionName) {
		// verifica se o modo de gravar logs está habilitado
		$salvarLogs = (bool) env('LOG_APLICACAO', false);
		if (!$salvarLogs) {
			return false;
		}

        // verifica se o nível será logado
        $logar = (env('LOG_APLICACAO_NIVEL', 3) < $logLevel) ? false : true;
        if (!$logar) {
            return false;
        }

        $logarFeature = ('PAGAMENTO_BOLETO' == $feature) ? true : false;
        if (!$logarFeature) {
            return false;
        }

        return true;
    }

    public static function testeLogAplicacao($logLevel, $feature, $actionName, $success, $mensagem, $datajson, $id)
	{
        $deveLogarAplicacao = Log::deveLogarAplicacao($logLevel, $feature, $actionName);;
        // tratamento para verificações durante o desenvolvimento
        if (("TESTE_LOG" == $feature) || (true)) {
            dd('LOGAR = '.$deveLogarAplicacao, "LOG_LEVEL = ".$logLevel,
               "FEATURE = ".$feature, "ACTION = ".$actionName, "SUCCESS = ".$success,
               "MENSAGEM = ".$mensagem, "DADOS = ".$datajson, "ID = ".$id);
        }
    }

	public static function saveLogCurl($postfields, $method = null, $response = null, $id = 0)
	{
		// verifica se o modo de gravar logs está habilitado
		$salvarLogs = (bool) env('LOG_CURL', false);
		if (!$salvarLogs) {
			return $id;
		}

		// cria uma nova entrada de log, caso contrário, atualiza a existente
		if (0 == $id) {

            $spsInfo = getSPS();

            $postfields_decode = json_decode($postfields, true);

            if (array_key_exists('FromTaxNumber',  $postfields_decode)) {
                $taxnumber = $postfields_decode['FromTaxNumber'];

                if ($taxnumber == $spsInfo->cnpj) {
                    $taxnumber = $postfields_decode['ToTaxNumber'];
                }

            } elseif (array_key_exists('TaxNumber', $postfields_decode)) {
                $taxnumber = $postfields_decode['TaxNumber'];
            } else {
                $taxnumber = 0;
            }

            if (!Auth::check()) {
                $userId = 1;
                $roleId = 1;

                $objCliente = buscarClienteOuMultisafePeloTaxnumber($taxnumber);
                $clientId = (get_class($objCliente) == 'App\Multisafe')
                    ? $objCliente->client_id
                    : $objCliente->id;

            } else {
                $userId = Auth::user()->id;
                $roleId = Auth::user()->role_id;
                $clientId = Auth::user()->client_id;
            }

			$log = new LogsCurl();
			$log->user_id = $userId;
	    	$log->role_id = $roleId;
	    	$log->client_id = $clientId;
	    	$log->taxnumber = $taxnumber;
	    	$log->method = $method;
	    	//$log->success = 0;
    		$log->datasent = $postfields;
			$log->sentdate = date('Y-m-d H:i:s');
		} else {
			$log = LogsCurl::where('id', '=', $id)->first();
		}

		// recupera as informações separadamente
		if ($response) {
			$response_decoded = json_decode($response, true);

			// inclui as informações da resposta, manter a quebra de linha para estruturar a escrita no banco de dados
			$log->datareceived = str_replace(',', ',
          ', $response);
			$log->success = ($response_decoded["Success"] == "false") ? 0 : 1;
			$log->message = (isset($response_decoded['Message'])) ? $response_decoded['Message'] : null;
			$log->documentnumber = (isset($response_decoded['DocumentNumber'])) ? $response_decoded['DocumentNumber'] : null;
			$log->alreadyexists = (isset($response_decoded['AlreadyExists'])) ? 1 : 0;
			$log->validation = (isset($response_decoded['Validation'])) ? serialize($response_decoded['Validation']) : null;
			//$log->entry = $response_decoded['Entry'];
			//$log->balance = (isset($response_decoded['Balance'])) ? $response_decoded['Balance'] : null;
			//$log->url = (isset($response_decoded['Url'])) ? $response_decoded['Url'] : null;
			$log->receiveddate = date('Y-m-d H:i:s');
		}
		$fluentd = new FluentdService('192.168.0.185', 8088);
		$responseLog = $fluentd->info("logscurl", json_encode($log));


		$log->save();
		return $log->id;
	}
}
