<?php

namespace App\Classes;

class FitBank
{
	private function sendCurlWIP($postfields) {

	    $sps = getSPS();

	    $credentials = base64_encode($sps->key.':'.$sps->secret);

	    $curl = curl_init();

	    if( env('FITBANK_ENV') == 'dev' ) $FITBANK_URL = env('FITBANK_SANDBOX');
	    else $FITBANK_URL = env('FITBANK_PROD');

	    curl_setopt_array($curl, array(
	      CURLOPT_URL => $FITBANK_URL,
	      CURLOPT_RETURNTRANSFER => true,
	      CURLOPT_ENCODING => "",
	      CURLOPT_MAXREDIRS => 10,
	      CURLOPT_TIMEOUT => 5,
	      CURLOPT_FOLLOWLOCATION => true,
	      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	      CURLOPT_CUSTOMREQUEST => "POST",
	      CURLOPT_POSTFIELDS =>$postfields,
	      CURLOPT_HTTPHEADER => array(
	        "Content-Type: application/json",
	        "Authorization: Basic ".$credentials
	      ),
	    ));

	    $response = curl_exec($curl);
	    $response_decoded = json_decode($response, true);

	    // dd( curl_errno($curl) );
	    curl_close($curl);
	    return $response_decoded;
	}

/*
	public function internalTransfer($fromTaxNumber, $toTaxNumber, $value, $identifier, Spsinfo $spsInfo, 
		$rateValue = 0, $cashbackValue = 0, $description = '') {

		$dataAtual = date("Y/m/d");

	    $curlParams = "{ \"Method\": \"InternalTransfer\",
	                \"PartnerId\": ".$spsInfo->partnerid.",
	                \"BusinessUnitId\": ".$spsInfo->businessunitid.",
	                \"FromTaxNumber\": \"".somenteNumeros($fromTaxNumber)."\",
	                \"ToTaxNumber\": \"".somenteNumeros($toTaxNumber)."\",
	                \"Value\": \"".$value."\",
	                \"RateValue\": \"".$rateValue."\",
	                \"TransferDate\": \"".$dataAtual."\",
	                \"Identifier\": \"".$identifier."\",
	                \"Description\": \"".$description."\",
	                \"CashBackValue\":\"".$cashbackValue."\"
	            }";
	    // CashBackValue é o valor cobrado do beneficiário. Deve SEMPRE ser menor que o valor da transferência

	    $transfere = sendCurl($curlParams);
	    //$transfere = $this->sendCurl($curlParams);

	    return $transfere;
	}
	*/

}